/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.resources;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.jayway.jsonpath.spi.JsonProviderFactory;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.xltest.domain.Event;
import com.xebialabs.xltest.domain.TestRun;
import com.xebialabs.xltest.domain.TestRunId;
import com.xebialabs.xltest.repository.TestRuns;
import com.xebialabs.xltest.service.EventDispatcher;
import com.xebialabs.xltest.service.TestRunStatusProvider;
import com.xebialabs.xltest.service.TestRunner;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
@Path(value="/test")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class TestController {
    private static final Logger LOG = LoggerFactory.getLogger(TestController.class);
    private final TestRunner testRunner;
    private final TestRunStatusProvider testRunStatusProvider;
    private final TestRuns testRuns;
    private final EventDispatcher eventDispatcher;

    @Autowired
    public TestController(TestRunner testRunner, EventDispatcher eventDispatcher, TestRunStatusProvider testRunStatusProvider, TestRuns testRuns) {
        this.testRunner = testRunner;
        this.testRunStatusProvider = testRunStatusProvider;
        this.testRuns = testRuns;
        this.eventDispatcher = eventDispatcher;
    }

    @POST
    @Path(value="/")
    public TestRun fireTest(TestRun testRun, @HeaderParam(value="xltest-base") String xlTestBase, @Context UriInfo uriInfo) throws IOException, InterruptedException {
        URI xlTestBaseUri = xlTestBase != null ? URI.create(xlTestBase + "/test") : uriInfo.getAbsolutePath();
        return this.testRunner.run(testRun, xlTestBaseUri);
    }

    @GET
    @Path(value="/")
    public Collection<TestRun> getTestRuns(@QueryParam(value="p") List<String> queries, @QueryParam(value="date") String queryDate) {
        SearchParameters searchParameters = new SearchParameters();
        LOG.info("Query test runs for fields {} on date {}", queries, (Object)queryDate);
        this.addQueryParameters(searchParameters, queries);
        Collection<TestRun> runs = this.testRuns.getTestRuns(searchParameters);
        if (queryDate != null) {
            DateTime startTime = DateTime.parse((String)queryDate);
            LOG.info("Query test runs from {}", (Object)startTime);
            final Interval dateRange = new Interval((ReadableInstant)startTime, (ReadableDuration)Duration.standardDays((long)1L));
            return Collections2.filter(runs, (Predicate)new Predicate<TestRun>(){

                public boolean apply(TestRun testRun) {
                    return testRun.getStartTime() != null && dateRange.contains(testRun.getStartTime().getTime());
                }
            });
        }
        return runs;
    }

    void addQueryParameters(SearchParameters searchParameters, List<String> queries) {
        for (String q : queries) {
            String[] nameValue = q.split(":", 2);
            if (nameValue.length != 2) {
                throw new IllegalArgumentException("query should have format 'field:value'");
            }
            searchParameters.addProperty(nameValue[0].trim(), nameValue[1].trim());
        }
    }

    @POST
    @Path(value="/{testRunId:.+}")
    public String receiveEvent(@Context HttpServletRequest request, @PathParam(value="testRunId") String testRunId, Event event) {
        LOG.info("Received event {} for run {}", (Object)event.getType(), (Object)testRunId);
        if ("STOP".equals(event.getType())) {
            LOG.info("Attempting to abort test run {} due to STOP event.", (Object)testRunId);
            this.testRunner.abort(new TestRunId(testRunId));
        } else {
            this.eventDispatcher.notify(new TestRunId(testRunId), new Event(event, Event.props("_host", request.getRemoteHost(), "run_id", new TestRunId(testRunId).getTopLevel().toString())));
        }
        return "";
    }

    @GET
    @Path(value="/{testRunId:.+}")
    public String getTestRun(@PathParam(value="testRunId") String testRunId) {
        TreeMap<String, Object> resultObject = new TreeMap<String, Object>();
        boolean running = this.testRunStatusProvider.isRunning(new TestRunId(testRunId));
        resultObject.put("running", running);
        if (!running) {
            resultObject.putAll(this.testRuns.getQualification(new TestRunId(testRunId)));
        }
        return JsonProviderFactory.createProvider().toJson(resultObject);
    }
}

