package com.xebialabs.xltest.service;

import com.xebialabs.xltest.domain.Event;
import com.xebialabs.xltest.domain.NoSuchEventPropertyException;
import com.xebialabs.xltest.domain.TestRunId;
import com.xebialabs.xltest.domain.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class SerialEventDispatcher extends EventDispatcher {
    private final static Logger LOG = LoggerFactory.getLogger(SerialEventDispatcher.class);

    private Set<TestRunId> runningTasks;

    public SerialEventDispatcher() {
        this.runningTasks = Collections.synchronizedSet(new HashSet<TestRunId>());
    }

    @Override
    public void invokeEventHandler(TestRunId testRunId, EventHandler handler, Event event) {
        runningTasks.add(testRunId);
        try {
            LOG.info("Invoking event for handler " + handler.getClass() + ": " + event);
            handler.onReceive(event);
        } catch (NoSuchEventPropertyException e) {
            LOG.info("Handler " + handler + " gave up: " + e.getMessage());
        } catch (Throwable e) {
            LOG.warn("Event handler threw event", e);
        } finally {
            runningTasks.remove(testRunId);
        }
    }

}
