package com.xebialabs.xltest.serialize;

import com.xebialabs.xltest.domain.TestRun;
import org.codehaus.jettison.json.JSONException;
import org.jboss.resteasy.plugins.providers.jaxb.json.JsonParsing;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

public abstract class BasicMessageBodyReader<T> implements MessageBodyReader<T> {
    @Override
    public boolean isReadable(Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    @Override
    public final T readFrom(Class<T> aClass, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> stringStringMultivaluedMap, InputStream inputStream) throws IOException, WebApplicationException {
        try {
            return readJson(JsonParsing.extractJsonMapString(new InputStreamReader(inputStream)));
        } catch (JSONException e) {
            throw new WebApplicationException(e, 400);
        } catch (ClassCastException e) {
            throw new WebApplicationException(e, 400);
        }
    }

    abstract protected T readJson(String s) throws JSONException;
}
