package com.xebialabs.xltest.domain;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;

@SuppressWarnings("serial")
@Metadata(description = "Text store base type", root = Metadata.ConfigurationItemRoot.CONFIGURATION)
public class TextStore extends Store {
	@Property(description = "filename to which records are appended, e.g. myeventstore.log")
	private String filename;
	@Property(description = "format of a line in the file using properties of the Record, e.g. \"${starttime} ${testcase} ${right} ${wrong}\"")
	private String format;
	
	public TextStore() {
	}

	public TextStore(String filename, String format) {
		super();
		this.filename = filename;
		this.format = format;
	}
	
	@Override
	public void store(Event event) {
		String line = format(event.getProperties()) + "\n";
		try {
			Writer output = new BufferedWriter(new FileWriter(filename, true));
			output.append(line);
			output.close();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	@Override
	public List<Event> getEventsOfRun(TestRunId runId) {
		// Events can not be returned from a text store, but implementing this method is mandatory for all Stores
		return new ArrayList<Event>();
	}
	
	@Override
	public List<Event> getEventsOfRun(TestRunId runId, Map queryParameters) {
		// Events can not be returned from a text store, but implementing this method is mandatory for all Stores
		return new ArrayList<Event>();
	}
	
	private String format(Map<String, Object> properties) {
		try {
			Template t = new Template("name", new StringReader(format), new Configuration());
			StringWriter sw = new StringWriter();
			t.process(properties, sw);
			return sw.toString();
		} catch (IOException e) {
			e.printStackTrace();
			return e.getMessage();
		} catch (TemplateException e) {
			e.printStackTrace();
			return e.getMessage();
		}
	}

	public String getFilename() {
		return filename;
	}

	public void setFilename(String filename) {
		this.filename = filename;
	}

	public String getFormat() {
		return format;
	}

	public void setFormat(String format) {
		this.format = format;
	}

}
