package com.xebialabs.xltest.domain;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.script.ScriptContext;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.repository.RepositoryService;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;

@SuppressWarnings("serial")
public class FreemarkerReport extends Report {

    private static Logger LOG = LoggerFactory.getLogger(FreemarkerReport.class);

    @Override
    public String compute(TestRun testRun) {
    	String format;
		try {
			format = readTemplateFile(getScriptLocation());
		} catch (IOException e) {
			e.printStackTrace();
			throw new RuntimeException("Could not perform freemarker report transformation.", e);
		}
    	Map<String, Object> templateProperties = new HashMap(getAttributes());
        templateProperties.put("testRun", testRun);
    	return format(templateProperties, format);
    }
    
    
    private String readTemplateFile(String fileName) throws IOException {
		InputStream is = this.getClass().getResourceAsStream("/" + fileName);
		BufferedReader br = new BufferedReader(new InputStreamReader(is));
		StringBuilder sb = new StringBuilder();
		String line;
		while ((line = br.readLine()) != null) {
			sb.append(line);
			sb.append("\n");
		}
		return sb.toString();
	}

	private String format(Map<String, Object> properties, String format) {
		try {
			Template t = new Template(getScriptLocation(), new StringReader(format), new Configuration());
			StringWriter sw = new StringWriter();
			t.process(properties, sw);
			return sw.toString();
		} catch (IOException e) {
			e.printStackTrace();
			return e.getMessage();
		} catch (TemplateException e) {
			e.printStackTrace();
			return e.getMessage();
		}
	}

}
