package com.xebialabs.xltest;

import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.webapp.WebAppContext;
import org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher;
import org.jboss.resteasy.plugins.server.servlet.ResteasyBootstrap;
import org.jboss.resteasy.plugins.spring.SpringContextLoaderListener;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;

public class XLTest {

    private Server server;

    public void startWebApp() throws Exception {
        org.eclipse.jetty.util.thread.QueuedThreadPool threadPool = new org.eclipse.jetty.util.thread.QueuedThreadPool();
        threadPool.setMinThreads(10);
        threadPool.setMaxThreads(1000);
        server = new Server(threadPool);

        ServerConnector connector = new ServerConnector(server);
        connector.setPort(webAppPortNumber());
        connector.setHost(webAppBindAddress());
        server.setConnectors(new Connector[]{connector});

        setupRestContext(server);
        
        server.start();
        server.setStopAtShutdown(true);
    }

    private String webAppBindAddress() {
        return System.getProperty("xltest.host", "0.0.0.0");
    }

    public int webAppPortNumber() {
        return Integer.getInteger("xltest.port", 8181);
    }

    public void stopWebApp() throws Exception {
        server.stop();
        server.join();
    }

    private void setupRestContext(Server server) {
        WebAppContext context;

        context = new WebAppContext();
        context.setContextPath("/xltest");

        context.setInitParameter("contextConfigLocation", ContextConfig.class.getName());
        context.setInitParameter("contextClass", AnnotationConfigWebApplicationContext.class.getName());
        context.addEventListener(new ResteasyBootstrap());
        context.addEventListener(new SpringContextLoaderListener()); // was: DeployitSpringContextLoaderListener

        ServletHolder servletHolder = new ServletHolder(
                HttpServletDispatcher.class);
        context.getInitParams().put("resteasy.servlet.mapping.prefix", "/");
        context.getInitParams().put(
                "resteasy.document.expand.entity.references", "false");
        context.addServlet(servletHolder, "/*");
        context.setResourceBase(".");
        // no persistency yet DefaultStorageProvider.setInstance(new Mime4jStorageProvider());

        server.setHandler(context);
    }

}
