/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.jmeter;

import com.xebialabs.xltest.jmeter.Feedback;
import com.xebialabs.xltest.jmeter.FeedbackEventSender;
import com.xebialabs.xltest.jmeter.FeedbackLogger;
import com.xebialabs.xltest.jmeter.Summary;
import com.xebialabs.xltest.jmeter.TestEnded;
import com.xebialabs.xltest.jmeter.TestStarted;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.engine.util.NoThreadClone;
import org.apache.jmeter.reporters.AbstractListenerElement;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleListener;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class XLTestLogger
extends AbstractListenerElement
implements SampleListener,
Serializable,
NoThreadClone,
TestStateListener {
    private static final Logger LOG = LoggingManager.getLoggerForClass();
    private Feedback<Object> feedback;

    public XLTestLogger() {
    }

    public XLTestLogger(Feedback<Object> feedback) {
        this.feedback = feedback;
    }

    public synchronized void sampleOccurred(SampleEvent se) {
        SampleResult res = se.getResult();
        if (!res.isSuccessful()) {
            this.feedback.found(new Summary(res.getStartTime(), res.getEndTime(), res.getErrorCount()));
            return;
        }
        AssertionResult[] assertions = res.getAssertionResults();
        if (assertions != null) {
            for (int i = 0; i < assertions.length; ++i) {
                AssertionResult assertion = assertions[i];
                if (!assertion.isError() && !assertion.isFailure()) continue;
                this.feedback.found(new Summary(res.getStartTime(), res.getEndTime(), res.getErrorCount(), assertion.getName(), assertion.getFailureMessage()));
                return;
            }
        }
    }

    public void sampleStarted(SampleEvent se) {
    }

    public void sampleStopped(SampleEvent se) {
    }

    public void testStarted() {
        this.feedback = this.getFeedback();
        this.feedback.found(new TestStarted(System.currentTimeMillis()));
    }

    public void testStarted(String string) {
        this.testStarted();
    }

    public void testEnded() {
        this.feedback.found(new TestEnded(System.currentTimeMillis()));
    }

    public void testEnded(String string) {
        this.testEnded();
    }

    public Object clone() {
        XLTestLogger o = (XLTestLogger)super.clone();
        o.feedback = this.feedback;
        return o;
    }

    private Feedback getFeedback() {
        Feedback feedback;
        if (this.feedback != null) {
            return this.feedback;
        }
        String xltestUrl = XLTestLogger.getXlTestUrl();
        if (xltestUrl != null) {
            try {
                feedback = new FeedbackEventSender(new URL(xltestUrl));
            }
            catch (MalformedURLException e) {
                LOG.error("Unable to create feedback sender: invalid url", (Throwable)e);
                feedback = new FeedbackLogger();
            }
        } else {
            feedback = new FeedbackLogger();
        }
        return feedback;
    }

    public static String getXlTestUrl() {
        return System.getenv("XLTEST_URL");
    }
}

