package com.xebialabs.xltest.jmeter;

import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.visualizers.gui.AbstractListenerGui;

import javax.swing.*;
import java.awt.*;

public class XLTestLoggerGui extends AbstractListenerGui {

    public String xltestUrl;

    public XLTestLoggerGui() {
        super();
        init();
    }

    @Override
    public String getStaticLabel() {
        return "XL Test Status Logger";
    }

    @Override
    public String getLabelResource() {
        return getClass().getCanonicalName();
    }

    @Override
    public TestElement createTestElement() {
        XLTestLogger te = new XLTestLogger();
        modifyTestElement(te);
        return te;
    }

    @Override
    public void modifyTestElement(TestElement te) {
        super.configureTestElement(te);
    }

    @Override
    public void configure(TestElement element) {
        super.configure(element);
        this.xltestUrl = ((XLTestLogger) element).getXlTestUrl();
    }

    private void init() {
        setLayout(new BorderLayout(0, 5));
        setBorder(makeBorder());
        JTextArea info = new JTextArea();
        info.setEditable(false);
        info.setWrapStyleWord(true);
        info.setOpaque(false);
        info.setLineWrap(true);
        info.setColumns(20);

        if (xltestUrl != null) {
            info.setText("XL Test result logger. Test results are reported to: " + xltestUrl);
        } else {
            info.setText("XL Test result logger. No results will be reported since the XLTEST_URL environment variable is not set.");
        }

        add(info, BorderLayout.CENTER);
    }
}