/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.jenkins;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.io.CharStreams;
import com.google.common.net.UrlEscapers;
import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.spi.JsonProvider;
import com.jayway.jsonpath.spi.JsonProviderFactory;
import com.xebialabs.xltest.jenkins.NumberSlavePair;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.jboss.resteasy.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JenkinsQueueInspector {
    private static final Logger LOG = LoggerFactory.getLogger((String)JenkinsQueueInspector.class.getName());
    public static final String SUCCESS = "SUCCESS";
    public static final int MINUTE = 60000;
    public static final int ONE_HOUR = 3600000;
    public static final String XLTEST_URL = "XLTEST_URL";
    public static final int BUILD_SUCCESS = 0;
    public static final int BUILD_FAILURE = 1;
    public static final int BUILD_TIMEOUT = 2;
    static final JsonPath BUILD_XLTEST_RESULT = JsonPath.compile((String)"$.result", (Filter[])new Filter[0]);
    private final String username;
    private final String password;
    private final String uniqueIdParameterName;
    private final String uniqueId;
    private final String jobName;
    private URL jenkinsBaseUrl;
    private Number buildNumber;
    private String slaveName;

    public JenkinsQueueInspector(URL url, String jobName, String uniqueId) {
        this.jenkinsBaseUrl = url;
        this.password = null;
        this.username = null;
        this.uniqueIdParameterName = XLTEST_URL;
        this.uniqueId = uniqueId;
        this.jobName = jobName;
    }

    public JenkinsQueueInspector(URL url, String jobName, String username, String password, String uniqueIdParameterName, String uniqueId) {
        this.jenkinsBaseUrl = url;
        this.jobName = jobName;
        this.username = username;
        this.password = password;
        this.uniqueIdParameterName = uniqueIdParameterName;
        this.uniqueId = uniqueId;
    }

    public int inspectNumberOfJobsInBuildQueue() throws Exception {
        StatusCodeAndContent statusCodeAndContent = null;
        for (int retries = 1200; statusCodeAndContent != null && statusCodeAndContent.statusCode != 200 && retries > 0; --retries) {
            statusCodeAndContent = this.httpGetRequest(this.jenkinsBaseUrl.toString() + "queue/api/json");
            if (statusCodeAndContent.statusCode == 200) continue;
            Thread.sleep(500L);
        }
        int numberOfItemsInQueue = statusCodeAndContent.pathCount("items");
        LOG.debug("found " + numberOfItemsInQueue + " jobs waiting in the queue");
        return numberOfItemsInQueue;
    }

    public String getSlaveName() {
        return this.slaveName;
    }

    public Number getQueueIdForBuildWithXlTestUrl() throws Exception {
        String url = this.jenkinsBaseUrl.toString() + "queue/api/json?tree=items[id,actions[parameters[*]]]";
        StatusCodeAndContent statusCodeAndContent = this.httpGetRequest(url);
        if (statusCodeAndContent.statusCode != 200) {
            LOG.warn("Calling " + url + " did return status code " + statusCodeAndContent.statusCode + ": " + statusCodeAndContent.json);
            return null;
        }
        return this.extractQueueIdFromBuildQueue((Map)statusCodeAndContent.json);
    }

    public boolean cancelQueuedBuild(Number id) throws Exception {
        StatusCodeAndContent statusCodeAndContent = this.httpPostRequest(this.jenkinsBaseUrl.toString() + "queue/cancelItem=" + id);
        return statusCodeAndContent.statusCode < 400;
    }

    public NumberSlavePair getNumberForBuildWithXlTestUrl() throws Exception {
        String url = new URL(this.jenkinsBaseUrl, "job/" + this.escape(this.jobName) + "/api/json?tree=builds[number,result,url,builtOn,actions[parameters[*]]]").toString();
        StatusCodeAndContent statusCodeAndContent = this.httpGetRequest(url);
        if (statusCodeAndContent.statusCode != 200) {
            LOG.warn("Calling " + url + " did return status code " + statusCodeAndContent.statusCode + ": " + statusCodeAndContent.json);
            return null;
        }
        Number buildNumber = this.extractBuildNumberFromJob((Map)statusCodeAndContent.json);
        String slave = this.extractSlaveFromJob((Map)statusCodeAndContent.json);
        return new NumberSlavePair(buildNumber, slave);
    }

    private String escape(String s) throws UnsupportedEncodingException {
        return UrlEscapers.urlFragmentEscaper().escape(s);
    }

    public NumberSlavePair waitForBuildNumber() throws Exception {
        for (int retries = 360; retries > 0; --retries) {
            NumberSlavePair numberSlavePair = this.getNumberForBuildWithXlTestUrl();
            if (numberSlavePair == null || numberSlavePair.getNumber() == null) {
                Number queueIdForBuildWithXlTestUrl = this.getQueueIdForBuildWithXlTestUrl();
                if (queueIdForBuildWithXlTestUrl != null) {
                    LOG.debug("Finding Jenkins Job for id " + this.uniqueId + " failed. Will retry in 5 seconds as we found it in the Queue with id: " + queueIdForBuildWithXlTestUrl);
                    Thread.sleep(5000L);
                    continue;
                }
                LOG.debug("Finding Jenkins Job for id " + this.uniqueId + " failed. It is also not in the Queue. We blame Jenkins. Will retry in 5 seconds anyway");
                Thread.sleep(5000L);
                continue;
            }
            LOG.debug("Finding Jenkins Job for id " + this.uniqueId + " succeeded. It is: " + numberSlavePair.getNumber());
            return numberSlavePair;
        }
        LOG.error("Finding Jenkins Job for URL " + this.uniqueId + " failed dramatically. We retried 360 times and now give up");
        return null;
    }

    public String buildResult() throws Exception {
        String url = new URL(this.jenkinsBaseUrl, "job/" + this.escape(this.jobName) + "/" + this.buildNumber + "/api/json?tree=number,result").toString();
        StatusCodeAndContent statusCodeAndContent = this.httpGetRequest(url);
        if (statusCodeAndContent.statusCode != 200) {
            LOG.warn("Calling " + url + " did return status code " + statusCodeAndContent.statusCode + ": " + statusCodeAndContent.json);
            return null;
        }
        return (String)BUILD_XLTEST_RESULT.read(statusCodeAndContent.json);
    }

    public int waitForJobToFinish(int timeout) throws Exception {
        LOG.info("Job {} for run {} is waiting in the build queue", (Object)this.jobName, (Object)this.uniqueId);
        try {
            String buildResult;
            NumberSlavePair buildNumberSlavePair = this.waitForBuildNumber();
            if (buildNumberSlavePair == null) {
                LOG.error("Jenkins Queue Inspector gave up. No clue what to do here");
            }
            this.buildNumber = buildNumberSlavePair.getNumber();
            this.slaveName = buildNumberSlavePair.getSlave();
            long timeoutTime = System.currentTimeMillis() + (long)(timeout > 0 ? timeout * 60000 : 3600000);
            if (LOG.isInfoEnabled()) {
                LOG.info("Job {} for run {} with time out {} should finish before {}", new Object[]{this.jobName, this.uniqueId, timeout, new Date(timeoutTime)});
            }
            while ((buildResult = this.buildResult()) == null && !this.timedOut(timeoutTime)) {
                this.sleepOnIt();
            }
            if (this.timedOut(timeoutTime)) {
                LOG.info("Job {} for run {} with time out {} just timed out", new Object[]{this.jobName, this.uniqueId, timeout});
                this.stopBuild();
                return 2;
            }
            if (!SUCCESS.equals(buildResult)) {
                LOG.info("Job {} for run {} did not finish successfully", (Object)this.jobName, (Object)this.uniqueId);
                return 1;
            }
            LOG.info("Job {} for run {} did finish successfully", (Object)this.jobName, (Object)this.uniqueId);
            return 0;
        }
        catch (InterruptedException ie) {
            this.cancelJobOnJenkins();
            throw ie;
        }
    }

    private boolean timedOut(long timeoutTime) {
        return System.currentTimeMillis() > timeoutTime;
    }

    private void sleepOnIt() throws InterruptedException {
        Thread.sleep(5000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopBuild() throws Exception {
        URL url = new URL(this.jenkinsBaseUrl, "job/" + this.escape(this.jobName) + "/" + this.buildNumber + "/stop");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        try {
            if (conn.getResponseCode() != 200) {
                LOG.warn("Calling " + url + " did return status code " + conn.getResponseCode() + ": " + CharStreams.toString((Readable)new InputStreamReader(conn.getInputStream())));
            }
        }
        finally {
            conn.disconnect();
        }
    }

    protected void cancelJobOnJenkins() {
        Number queueId = null;
        try {
            queueId = this.getQueueIdForBuildWithXlTestUrl();
            if (queueId != null && this.cancelQueuedBuild(queueId)) {
                return;
            }
        }
        catch (Exception e) {
            LOG.error("Unable to remove build {} from queue", (Object)queueId, (Object)e);
        }
        try {
            if (this.buildNumber == null) {
                this.buildNumber = this.waitForBuildNumber().getNumber();
            }
            if (this.buildNumber != null) {
                this.stopBuild();
            }
        }
        catch (Exception e) {
            LOG.error("Unable to stop build {}/{}", new Object[]{this.jobName, this.buildNumber, e});
        }
    }

    Number extractQueueIdFromBuildQueue(Map<String, List<Map<String, Object>>> json) {
        return (Number)this.extractIdFromJenkinsResponse(json, "items", "id");
    }

    Number extractBuildNumberFromJob(Map<String, List<Map<String, Object>>> json) {
        return (Number)this.extractIdFromJenkinsResponse(json, "builds", "number");
    }

    String extractSlaveFromJob(Map<String, List<Map<String, Object>>> json) {
        return (String)this.extractIdFromJenkinsResponse(json, "builds", "builtOn");
    }

    private Object extractIdFromJenkinsResponse(Map<String, List<Map<String, Object>>> builds, String groupName, String idName) {
        for (Map<String, Object> build : builds.get(groupName)) {
            List parameters;
            List actions = (List)build.get("actions");
            if (actions == null || actions.size() == 0 || (parameters = (List)((Map)actions.get(0)).get("parameters")) == null || parameters.size() == 0) continue;
            for (Map parameter : parameters) {
                if (!this.uniqueIdParameterName.equals(parameter.get("name")) || !this.uniqueId.equals(parameter.get("value"))) continue;
                return build.get(idName);
            }
        }
        return null;
    }

    private StatusCodeAndContent httpGetRequest(String url) throws IOException {
        return this.httpRequest("GET", url);
    }

    private StatusCodeAndContent httpPostRequest(String url) throws IOException {
        return this.httpRequest("POST", url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StatusCodeAndContent httpRequest(String method, String url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        try {
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setInstanceFollowRedirects(false);
            connection.setUseCaches(false);
            connection.setRequestMethod(method);
            if (!Strings.isNullOrEmpty((String)this.username)) {
                String userPassword = this.username + ":" + (this.password != null ? this.password : "");
                String encoding = new String(Base64.encodeBytes((byte[])userPassword.getBytes()));
                connection.setRequestProperty("Authorization", "Basic " + encoding);
            }
            int statusCode = connection.getResponseCode();
            String content = CharStreams.toString((Readable)new InputStreamReader(connection.getInputStream(), Charsets.UTF_8));
            StatusCodeAndContent statusCodeAndContent = new StatusCodeAndContent(statusCode, content);
            return statusCodeAndContent;
        }
        finally {
            connection.disconnect();
        }
    }

    private static class StatusCodeAndContent {
        private final JsonProvider jsonProvider = JsonProviderFactory.createProvider();
        private final int statusCode;
        private final Object json;

        public StatusCodeAndContent(int statusCode, String content) {
            this.statusCode = statusCode;
            this.json = this.jsonProvider.parse(content);
        }

        public <T> T path(String path) {
            return (T)JsonPath.read((Object)this.json, (String)path, (Filter[])new Filter[0]);
        }

        public int pathCount(String path) {
            Object results = JsonPath.read((Object)this.json, (String)path, (Filter[])new Filter[0]);
            if (results instanceof JSONArray) {
                return ((JSONArray)results).size();
            }
            if (results instanceof JSONObject) {
                return ((JSONObject)results).size();
            }
            return results != null ? 1 : 0;
        }
    }
}

