package com.xebialabs.xltest.jenkins;

import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.spi.BaseOverthereFile;

import java.io.*;
import java.util.List;

import static com.google.common.collect.Lists.newArrayList;
import static com.xebialabs.xltest.jenkins.JenkinsConnection.JENKINS_PROTOCOL;

public class JenkinsFile extends BaseOverthereFile<JenkinsConnection> {

    private final String path;

    public JenkinsFile(JenkinsConnection connection, String path) {
        super(connection);
        this.path = path;
    }

    public JenkinsFile(JenkinsConnection connection, JenkinsFile parent, String path) {
        super(connection);
        this.path = parent.getPath() + "/" + path;
    }

    @Override
    public String toString() {
        return JENKINS_PROTOCOL + ":" + path;
    }

    @Override
    public String getPath() {
        return path;
    }

    @Override
    public String getName() {
        return new File(path).getName();
    }

    @Override
    public OverthereFile getParentFile() {
        return new JenkinsFile(connection, new File(path).getParent());
    }

    @Override
    public boolean exists() {
        return connection.getAbsoluteFileInLocalWorkspaceDirectory(path).exists();
    }

    @Override
    public boolean canRead() {
        return exists();
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    @Override
    public boolean canExecute() {
        return false;
    }

    @Override
    public boolean isFile() {
        return connection.getAbsoluteFileInLocalWorkspaceDirectory(path).isFile();
    }

    @Override
    public boolean isDirectory() {
        return connection.getAbsoluteFileInLocalWorkspaceDirectory(path).isDirectory();
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public long lastModified() {
        return 0;
    }

    @Override
    public long length() {
        return connection.getAbsoluteFileInLocalWorkspaceDirectory(path).length();
    }

    @Override
    public InputStream getInputStream() {
        try {
            return new FileInputStream(connection.getAbsoluteFileInLocalWorkspaceDirectory(path));
        } catch (FileNotFoundException exc) {
            throw new RuntimeIOException("Cannot open " + this + " for reading", exc);
        }

    }

    @Override
    public OutputStream getOutputStream() {
        try {
            return new FileOutputStream(connection.getAbsoluteFileInLocalWorkspaceDirectory(path));
        } catch (FileNotFoundException exc) {
            throw new RuntimeIOException("Cannot open " + this + " for reading", exc);
        }
    }

    @Override
    public void setExecutable(boolean executable) {
        // no-op
    }

    @Override
    public void delete() {
        // no-op
    }

    @Override
    public List<OverthereFile> listFiles() {
        List<OverthereFile> list = newArrayList();
        File absoluteLocalFile = connection.getAbsoluteFileInLocalWorkspaceDirectory(path);
        int tempDirLength = absoluteLocalFile.getPath().length() - path.length();
        if (absoluteLocalFile == null) {
            return list;
        }
        File[] files = absoluteLocalFile.listFiles();
        if (files == null) {
            return list;
        }
        for (File each : files) {
            list.add(new JenkinsFile(connection, each.getPath().substring(tempDirLength)));
        }
        return list;
    }

    @Override
    public void mkdir() {
        // no-op
    }

    @Override
    public void mkdirs() {
        // no-op
    }

    @Override
    public void renameTo(OverthereFile dest) {
        // no-op
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        JenkinsFile that = (JenkinsFile) o;

        if (!path.equals(that.path)) return false;

        return true;
    }

    @Override
    public int hashCode() {
        return path.hashCode();
    }
}
