/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.jenkins;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.tasker.TaskStep;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.xltest.domain.Event;
import com.xebialabs.xltest.domain.TestRun;
import com.xebialabs.xltest.domain.TestRunId;
import com.xebialabs.xltest.domain.TestSetDefinition;
import com.xebialabs.xltest.jenkins.JenkinsJobScheduler;
import com.xebialabs.xltest.jenkins.JenkinsQueueInspector;
import com.xebialabs.xltest.jenkins.NumberSlavePair;
import com.xebialabs.xltest.plan.TestPlan;
import com.xebialabs.xltest.repository.EventNotifier;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.ws.rs.core.UriBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Metadata(description="Jenkins Test run base type", root=Metadata.ConfigurationItemRoot.APPLICATIONS, virtual=true)
public class JenkinsTestRun
extends TestRun {
    private static final Logger LOG = LoggerFactory.getLogger((String)JenkinsTestRun.class.getName());
    private static final Object SCHEDULE_LOCK = new Object();
    public static final int MINUTE = 60000;
    public static final int ONE_HOUR = 3600000;
    public static final String SUCCESS = "SUCCESS";
    @Property
    private String jenkinsUri;
    @Property
    private String jobName;
    @Property
    private int maxQueueSize;
    @Property(description="target operating system", hidden=true, defaultValue="UNIX")
    private OperatingSystemFamily targetOsType;
    @Autowired
    private transient EventNotifier eventNotifier;
    private transient long testChildRunId = 0L;

    protected List<StepState> getSteps(TestPlan testPlan) {
        return Lists.newArrayList((Object[])new StepState[]{new TaskStep((Step)new JenkinsExecutionStep(testPlan))});
    }

    private void updateParameterMapWithTestRunProperties(Map<String, Object> parameters) {
        for (PropertyDescriptor pd : this.getType().getDescriptor().getPropertyDescriptors()) {
            Object value = pd.get((ConfigurationItem)this);
            if (value == null) continue;
            parameters.put(pd.getName(), value);
        }
    }

    private void updateParameterMapWithTestSetDefinitionProperties(TestSetDefinition testSetDefinition, Map<String, Object> parameters) {
        for (PropertyDescriptor pd : testSetDefinition.getType().getDescriptor().getPropertyDescriptors()) {
            Object value = pd.get((ConfigurationItem)testSetDefinition);
            if (value == null) continue;
            parameters.put(pd.getName(), value);
        }
    }

    private void ensureJobQueueDoesNotExceed(int numberOfItems) throws Exception {
        JenkinsQueueInspector inspector = this.newQueueInspector();
        while (inspector.inspectNumberOfJobsInBuildQueue() >= numberOfItems) {
            this.sleepOnIt();
        }
    }

    private void waitForJobToFinish(TestRunId subRunId, TestSetDefinition testSet, String xlTestUrl) throws Exception {
        int timeout = testSet.getTimeout();
        Number buildNumber = null;
        JenkinsQueueInspector queueInspector = this.newQueueInspector();
        LOG.info("Job {} for run {} is waiting in the build queue", (Object)this.jobName, (Object)xlTestUrl);
        try {
            String buildResult;
            NumberSlavePair buildNumberSlavePair = queueInspector.waitForNumberForBuildWithXlTestUrl(this.jobName, xlTestUrl);
            buildNumber = buildNumberSlavePair.getNumber();
            String slave = buildNumberSlavePair.getSlave();
            long timeoutTime = System.currentTimeMillis() + (long)(timeout > 0 ? timeout * 60000 : 3600000);
            if (LOG.isInfoEnabled()) {
                LOG.info("Job {} for run {} with time out {} should finish before {}", new Object[]{this.jobName, xlTestUrl, timeout, new Date(timeoutTime)});
            }
            Event startedEvent = this.makeJobEvent(subRunId, "started", testSet, slave);
            Number startMoment = (Number)startedEvent.get("_ts");
            this.sendEvent(startedEvent);
            while ((buildResult = queueInspector.buildResult(this.jobName, buildNumber)) == null && !this.timedOut(timeoutTime)) {
                this.sleepOnIt();
            }
            if (this.timedOut(timeoutTime)) {
                LOG.info("Job {} for run {} with time out {} just timed out", new Object[]{this.jobName, xlTestUrl, timeout});
                queueInspector.stopBuild(this.jobName, buildNumber);
                this.sendEvent(this.makeJobEvent(subRunId, "finished", "timeout", testSet, startMoment, slave));
            } else if (!SUCCESS.equals(buildResult)) {
                LOG.info("Job {} for run {} did not finish successfully", (Object)this.jobName, (Object)xlTestUrl);
                this.sendEvent(this.makeJobEvent(subRunId, "finished", buildResult == null ? "NULL" : buildResult.toLowerCase(), testSet, startMoment, slave));
            } else {
                this.sendEvent(this.makeJobEvent(subRunId, "finished", "success", testSet, startMoment, slave));
                LOG.info("Job {} for run {} did finish successfully", (Object)this.jobName, (Object)xlTestUrl);
            }
        }
        catch (InterruptedException ie) {
            this.cancelJobOnJenkins(xlTestUrl, buildNumber, queueInspector);
            throw ie;
        }
    }

    private void cancelJobOnJenkins(String xlTestUrl, Number buildNumber, JenkinsQueueInspector queueInspector) {
        Number queueId = null;
        try {
            queueId = queueInspector.getQueueIdForBuildWithXlTestUrl(xlTestUrl);
            if (queueId != null && queueInspector.cancelQueuedBuild(queueId)) {
                return;
            }
        }
        catch (Exception e) {
            LOG.error("Unable to remove build {} from queue", (Object)queueId, (Object)e);
        }
        try {
            if (buildNumber == null) {
                buildNumber = queueInspector.waitForNumberForBuildWithXlTestUrl(this.jobName, xlTestUrl).getNumber();
            }
            if (buildNumber != null) {
                queueInspector.stopBuild(this.jobName, buildNumber);
            }
        }
        catch (Exception e) {
            LOG.error("Unable to stop build {}/{}", new Object[]{this.jobName, buildNumber, e});
        }
    }

    private void sendEvent(Event event) {
        this.eventNotifier.notify(new TestRunId(this.getName()), event);
    }

    private Event makeJobEvent(TestRunId subRunId, String status, String reason, TestSetDefinition testSet, Number startMoment, String slave) {
        Object property;
        TreeMap<String, Object> props = new TreeMap<String, Object>();
        props.put("type", "jobStatus");
        props.put("status", status);
        props.put("subRunId", subRunId.toString());
        props.put("run_id", this.getName());
        if (slave != null) {
            props.put("slave", slave);
        }
        if (reason != null) {
            props.put("reason", reason);
        }
        if (startMoment != null) {
            props.put("started", startMoment);
        }
        for (PropertyDescriptor descriptor : this.getType().getDescriptor().getPropertyDescriptors()) {
            property = this.getProperty(descriptor.getName());
            if (property instanceof Number || property instanceof Boolean) {
                props.put(descriptor.getName(), property);
                continue;
            }
            if (property == null) continue;
            props.put(descriptor.getName(), property.toString());
        }
        for (PropertyDescriptor descriptor : testSet.getType().getDescriptor().getPropertyDescriptors()) {
            property = testSet.getProperty(descriptor.getName());
            if (property instanceof Number || property instanceof Boolean) {
                props.put(descriptor.getName(), property);
                continue;
            }
            if (property == null) continue;
            props.put(descriptor.getName(), property.toString());
        }
        return new Event(props);
    }

    private Event makeJobEvent(TestRunId subRunId, String status, TestSetDefinition testSet, String slave) {
        return this.makeJobEvent(subRunId, status, null, testSet, null, slave);
    }

    private boolean timedOut(long timeoutTime) {
        return System.currentTimeMillis() > timeoutTime;
    }

    private JenkinsJobScheduler newJobScheduler() {
        try {
            return new JenkinsJobScheduler(new URL(this.jenkinsUri));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Invalid url: " + this.jenkinsUri, e);
        }
    }

    private JenkinsQueueInspector newQueueInspector() {
        try {
            return new JenkinsQueueInspector(new URL(this.jenkinsUri));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Invalid url: " + this.jenkinsUri, e);
        }
    }

    private void sleepOnIt() {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private synchronized TestRunId generateChildRunId() {
        return new TestRunId(String.valueOf(this.testChildRunId++));
    }

    private URI getTestRunUrl(URI absolutePath, TestRunId testRunId) {
        return UriBuilder.fromUri((URI)absolutePath).path(testRunId.toString()).build(new Object[0]);
    }

    public class JenkinsExecutionStep
    implements Step {
        private TestPlan testPlan;

        public JenkinsExecutionStep(TestPlan testPlan) {
            this.testPlan = testPlan;
        }

        public int getOrder() {
            return 0;
        }

        public String getDescription() {
            return String.format("Executing Test set '%s' on local environment", JenkinsTestRun.this.getTestSetDefinition().getId());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public StepExitCode execute(ExecutionContext executionContext) throws Exception {
            TestRunId subRunId = JenkinsTestRun.this.generateChildRunId();
            LOG.info("Scheduling Jenkins job for " + JenkinsTestRun.this.getTestRunId());
            TreeMap<String, Object> parameters = new TreeMap<String, Object>();
            URI xlTestUrl = JenkinsTestRun.this.getTestRunUrl(JenkinsTestRun.this.getUri(), subRunId);
            JenkinsTestRun.this.updateParameterMapWithTestRunProperties(parameters);
            JenkinsTestRun.this.updateParameterMapWithTestSetDefinitionProperties(this.testPlan.getTestSet(), parameters);
            parameters.put("XLTEST_URL", xlTestUrl);
            parameters.put("commandLine", this.testPlan.getCommandLine().toCommandLine(JenkinsTestRun.this.targetOsType, false));
            Object object = SCHEDULE_LOCK;
            synchronized (object) {
                JenkinsJobScheduler scheduler = JenkinsTestRun.this.newJobScheduler();
                JenkinsTestRun.this.ensureJobQueueDoesNotExceed(JenkinsTestRun.this.maxQueueSize);
                scheduler.scheduleJenkinsJobWithParameters(JenkinsTestRun.this.jobName, parameters);
            }
            JenkinsTestRun.this.waitForJobToFinish(subRunId, this.testPlan.getTestSet(), xlTestUrl.toString());
            return StepExitCode.SUCCESS;
        }
    }
}

