/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.jenkins;

import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.spi.JsonProviderFactory;
import com.xebialabs.xltest.jenkins.NumberSlavePair;
import com.xebialabs.xltest.utils.JsonOverHttpHelper;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JenkinsQueueInspector {
    private static final Logger LOG = LoggerFactory.getLogger((String)JenkinsQueueInspector.class.getName());
    public static final String XLTEST_URL = "XLTEST_URL";
    static final JsonPath BUILD_XLTEST_RESULT = JsonPath.compile((String)"$.result", (Filter[])new Filter[0]);
    private URL jenkinsBaseUrl;

    public JenkinsQueueInspector(URL url) {
        this.jenkinsBaseUrl = url;
    }

    public int inspectNumberOfJobsInBuildQueue() throws Exception {
        JsonOverHttpHelper httpHelper = new JsonOverHttpHelper();
        httpHelper.httpGetRequest(this.jenkinsBaseUrl.toString() + "/queue/api/json");
        int numberOfItemsInQueue = httpHelper.pathCount("items");
        LOG.info("found " + numberOfItemsInQueue + " jobs waiting in the queue");
        return numberOfItemsInQueue;
    }

    public Number getQueueIdForBuildWithXlTestUrl(String xlTestUrl) throws Exception {
        JsonOverHttpHelper httpHelper = new JsonOverHttpHelper();
        String url = this.jenkinsBaseUrl.toString() + "/queue/api/json?tree=items[id,actions[parameters[*]]]";
        httpHelper.httpGetRequest(url);
        if (httpHelper.statusCode() != 200) {
            LOG.warn("Calling " + url + " did return status code " + httpHelper.statusCode() + ": " + httpHelper.content());
            return null;
        }
        return this.extractQueueIdFromBuildQueue(httpHelper.content(), xlTestUrl);
    }

    public boolean cancelQueuedBuild(Number id) throws Exception {
        JsonOverHttpHelper httpHelper = new JsonOverHttpHelper();
        httpHelper.httpPostRequest(this.jenkinsBaseUrl.toString() + "/queue/cancelItem=" + id, "");
        return httpHelper.statusCode() < 400;
    }

    public NumberSlavePair getNumberForBuildWithXlTestUrl(String jobName, String xlTestUrl) throws Exception {
        JsonOverHttpHelper httpHelper = new JsonOverHttpHelper();
        String url = this.jenkinsBaseUrl.toString() + "/job/" + jobName + "/api/json?tree=builds[number,result,url,builtOn,actions[parameters[*]]]";
        httpHelper.httpGetRequest(url);
        String content = httpHelper.content();
        if (httpHelper.statusCode() != 200) {
            LOG.warn("Calling " + url + " did return status code " + httpHelper.statusCode() + ": " + content);
            return null;
        }
        Number buildNumber = this.extractBuildNumberFromJob(content, xlTestUrl);
        String slave = this.extractSlaveFromJob(content, xlTestUrl);
        return new NumberSlavePair(buildNumber, slave);
    }

    public NumberSlavePair waitForNumberForBuildWithXlTestUrl(String jobName, String xlTestUrl) throws Exception {
        Number number = null;
        for (int retries = 360; retries > 0; --retries) {
            NumberSlavePair numberSlavePair = this.getNumberForBuildWithXlTestUrl(jobName, xlTestUrl);
            number = numberSlavePair.getNumber();
            if (number == null) {
                Number queueIdForBuildWithXlTestUrl = this.getQueueIdForBuildWithXlTestUrl(xlTestUrl);
                if (queueIdForBuildWithXlTestUrl != null) {
                    LOG.error("Finding Jenkins Job for URL " + xlTestUrl + " failed. Will retry in 5 seconds as we found it in the Queue with id: " + queueIdForBuildWithXlTestUrl);
                    Thread.sleep(5000L);
                    continue;
                }
                LOG.error("Finding Jenkins Job for URL " + xlTestUrl + " failed. It is also not in the Queue. We blame Jenkins. Will retry in 5 seconds anyway");
                Thread.sleep(5000L);
                continue;
            }
            LOG.error("Finding Jenkins Job for URL " + xlTestUrl + " succeeded. It is: " + number);
            return numberSlavePair;
        }
        LOG.error("Finding Jenkins Job for URL " + xlTestUrl + " failed dramatically. We retried 360 times and now give up");
        return null;
    }

    public String buildResult(String jobName, Number buildNumber) throws Exception {
        JsonOverHttpHelper httpHelper = new JsonOverHttpHelper();
        String url = this.jenkinsBaseUrl.toString() + "/job/" + jobName + "/" + buildNumber + "/api/json?tree=number,result";
        httpHelper.httpGetRequest(url);
        if (httpHelper.statusCode() != 200) {
            LOG.warn("Calling " + url + " did return status code " + httpHelper.statusCode() + ": " + httpHelper.content());
            return null;
        }
        return (String)BUILD_XLTEST_RESULT.read(httpHelper.content());
    }

    public void stopBuild(String jobName, Number buildNumber) throws Exception {
        JsonOverHttpHelper httpHelper = new JsonOverHttpHelper();
        String url = this.jenkinsBaseUrl.toString() + "/job/" + jobName + "/" + buildNumber + "/stop";
        httpHelper.httpGetRequest(url);
        if (httpHelper.statusCode() != 200) {
            LOG.warn("Calling " + url + " did return status code " + httpHelper.statusCode() + ": " + httpHelper.content());
        }
    }

    Number extractQueueIdFromBuildQueue(String json, String xlTestUrl) {
        return (Number)this.extractIdFromJenkinsResponse(json, xlTestUrl, "items", "id");
    }

    Number extractBuildNumberFromJob(String json, String xlTestUrl) {
        return (Number)this.extractIdFromJenkinsResponse(json, xlTestUrl, "builds", "number");
    }

    String extractSlaveFromJob(String json, String xlTestUrl) {
        return (String)this.extractIdFromJenkinsResponse(json, xlTestUrl, "builds", "builtOn");
    }

    private Object extractIdFromJenkinsResponse(String json, String xlTestUrl, String groupName, String idName) {
        Map builds = (Map)JsonProviderFactory.createProvider().parse(json);
        for (Map build : (List)builds.get(groupName)) {
            List parameters;
            List actions = (List)build.get("actions");
            if (actions == null || actions.size() == 0 || (parameters = (List)((Map)actions.get(0)).get("parameters")) == null || parameters.size() == 0) continue;
            for (Map parameter : parameters) {
                if (!XLTEST_URL.equals(parameter.get("name")) || !xlTestUrl.equals(parameter.get("value"))) continue;
                return build.get(idName);
            }
        }
        return null;
    }
}

