/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.jenkins;

import com.xebialabs.xltest.utils.JsonOverHttpHelper;
import java.net.URL;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JenkinsJobScheduler {
    private static final Logger LOG = LoggerFactory.getLogger((String)JenkinsJobScheduler.class.getName());
    private URL jenkinsBaseUrl;

    public JenkinsJobScheduler(URL url) {
        this.jenkinsBaseUrl = url;
    }

    public void scheduleJenkinsJobWithParameters(String jobName, Map<String, Object> parameters) throws Exception {
        JsonOverHttpHelper httpHelper = new JsonOverHttpHelper();
        String content = this.makeContent(parameters);
        httpHelper.setContentType("application/x-www-form-urlencoded;charset=UTF-8");
        httpHelper.httpPostRequest(this.jenkinsBaseUrl.toString() + "/job/" + jobName + "/buildWithParameters", content);
        LOG.info("Scheduled job: " + jobName + " with parameters: " + parameters.toString() + ", response code: " + httpHelper.statusCode());
    }

    private String makeContent(Map<String, Object> parameters) {
        StringBuilder sb = new StringBuilder();
        if (parameters != null) {
            for (String key : parameters.keySet()) {
                sb.append(key);
                sb.append('=');
                sb.append(parameters.get(key));
                sb.append('&');
            }
        }
        return sb.toString().substring(0, sb.toString().length() - 1);
    }
}

