package com.xebialabs.xltest.jenkins;

import com.xebialabs.xltest.utils.JsonOverHttpHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.net.URL;
import java.util.Map;

/**
 * Sends events to XL Test with information found in the wiki pages.
 */
public class JenkinsJobScheduler {
    private static final Logger LOG = LoggerFactory.getLogger(JenkinsJobScheduler.class.getName());

    // the jenkins base url is something like: "http://localhost:8080"
    private URL jenkinsBaseUrl;

    public JenkinsJobScheduler(URL url) {
        this.jenkinsBaseUrl = url;
    }

    public void scheduleJenkinsJobWithParameters(String jobName, Map<String, Object> parameters) throws Exception {
        JsonOverHttpHelper httpHelper = new JsonOverHttpHelper();

        String content = makeContent(parameters);
        httpHelper.setContentType("application/x-www-form-urlencoded;charset=UTF-8");
        httpHelper.httpPostRequest(jenkinsBaseUrl.toString() + "/job/" + jobName + "/buildWithParameters", content);

        LOG.info("Scheduled job: " + jobName + " with parameters: " + parameters.toString() + ", response code: " + httpHelper.statusCode());
    }

	private String makeContent(Map<String, Object> parameters) {
		StringBuilder sb = new StringBuilder();
		if (parameters != null) {
			for (String key : parameters.keySet()) {
				sb.append(key);
				sb.append('=');
				sb.append(parameters.get(key));
				sb.append('&');
			}
		}
		return sb.toString().substring(0, sb.toString().length() - 1);
	}
}
