package com.xebialabs.xltest.gatling;

public class Line {
	private String[] parts;
    private String simulationName;

    static Line parseLine(String strLine) {
		Line line = new Line();
		line.parts = strLine.split("\\t");
		return line;
	}

	public boolean isRunLine() {
		return getParts()[2].equals("RUN");
	}
	
	public boolean isRequestLine() {
		return getParts()[2].equals("REQUEST");
	}
	
	public boolean isStartLine() {
		return getParts()[3].equals("START");
	}
	
	public boolean isEndLine() {
		return getParts()[3].equals("END");
	}
	
	public String getUserId() {
		String part = getParts()[1];
		return part.substring(part.lastIndexOf('-'), part.length());
	}
	
	public String getRequestDescription() {
		// skip 3 at start, 5 at end
		StringBuilder sb = new StringBuilder();
		for (int i = 3; i < getParts().length - 8; i++) {
			sb.append(getParts()[i]);
			sb.append(" ");
		}
		return sb.toString();
	}
	
	public long getStartTime() {
		if (isStartLine() || isEndLine()) {
			return Long.parseLong(getParts()[4]);
		}
		if (isRunLine()) {
			return Long.parseLong(getParts()[3]);
		}
		throw new RuntimeException("You can't derive the start time from a non START, END, or RUN line: " + getParts());
	}
	
	public long getEndTime() {
		if (isEndLine()) {
			return Long.parseLong(getParts()[5]);
		}
		throw new RuntimeException("You can't derive the end time from a non END line: " + getParts());
	}
	
	public String getStatus() {
		if (isRequestLine()) {
			return getParts()[getParts().length - 1];
		}
		throw new RuntimeException("You can't derive the status from a non REQUEST line: " + getParts());
	}
	
	public String[] getParts() {
		return parts;
	}

	public void setParts(String[] parts) {
		this.parts = parts;
	}

    public String getSimulationName() {
        if (isRunLine()) {
            return getParts()[1];
        }
        throw new IllegalAccessError("Simulation name can only be retrieved from first line of the log");
    }
}
