package com.xebialabs.xltest.fitnesse;

import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.xltest.domain.*;
import com.xebialabs.xltest.utils.TestToolCategory;
import com.xebialabs.xltest.utils.glob.FileMatcher;

import java.util.*;

public class FitNesseTestTool extends BaseTestTool {

    @Override
    public String getName() {
        return "FitNesse";
    }

    @Override
    public Collection<OverthereFile> findTestResultPaths(FileMatcher fileMatcher) {
        Collection<OverthereFile> testResultFiles = super.findTestResultPaths(fileMatcher);
        Set<OverthereFile> testResultDirectories = new HashSet<>();
        for (OverthereFile resultFile : testResultFiles) {
            // Look for parent's parent, since we check for files/testResults
            testResultDirectories.add(resultFile.getParentFile().getParentFile());
        }
        return testResultDirectories;
    }

    @Override
    public List<Importable> findImportables(OverthereFile remoteResultPath, FileMatcher fileMatcher) {
        LocalFile resultPath = retrieveFiles(remoteResultPath);

        Collection<OverthereFile> fitNesseRoots = findTestResultPaths(fileMatcher);

        try {
            List<Importable> importables = new ArrayList<>();
            for (OverthereFile fitNesseRoot : fitNesseRoots) {
                LocalFile localFile = (LocalFile) fitNesseRoot;
                importables.addAll(new PageHistoryExtractor(localFile.getFile()).tellMeAboutAllSuites());
            }
            return importables;
        } catch (Exception e) {
            throw new RuntimeException("Unable to determine what to import from FitNesse path " + remoteResultPath, e);
        }
    }

    @Override
    public String getSearchPattern() {
        return "**/files/testResults";
    }
    
	@Override
	public String getCategory() {
		return TestToolCategory.FUNCTIONAL;
	}

}
