/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.fitnesse;

import fitnesse.testsystems.slim.HtmlTable;
import fitnesse.testsystems.slim.HtmlTableScanner;
import fitnesse.wiki.WikiPage;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.htmlparser.Node;
import org.htmlparser.NodeFilter;
import org.htmlparser.filters.NodeClassFilter;
import org.htmlparser.tags.LinkTag;
import org.htmlparser.tags.TableColumn;
import org.htmlparser.tags.TableRow;
import org.htmlparser.tags.TableTag;
import org.htmlparser.util.NodeList;

public class TestCaseTable
implements Iterable<Map<String, String>> {
    private final HtmlTable table;

    public TestCaseTable(HtmlTable table) {
        this.table = table;
    }

    public static TestCaseTable fromPage(WikiPage wikiPage) {
        String html = wikiPage.readOnlyData().getHtml();
        HtmlTableScanner scanner = new HtmlTableScanner(html);
        Iterator iterator = scanner.iterator();
        if (iterator.hasNext()) {
            return new TestCaseTable((HtmlTable)iterator.next());
        }
        return new TestCaseTable(null);
    }

    public int rows() {
        return this.table != null ? this.table.getRowCount() - 1 : 0;
    }

    public boolean isEmpty() {
        return this.rows() == 0;
    }

    public List<Map<String, String>> asKeyValuePairs() {
        return this.table != null ? TestCaseTable.asList(this) : new LinkedList<Map<String, String>>();
    }

    @Override
    public Iterator<Map<String, String>> iterator() {
        TableTag tableTag = this.table.getTableNode();
        final NodeList rows = TestCaseTable.getRows(tableTag);
        final int rowCount = rows.size();
        final NodeList headRow = this.getCells(rows.elementAt(0));
        return new Iterator<Map<String, String>>(){
            int rowNumber = 1;

            @Override
            public boolean hasNext() {
                return this.rowNumber < rowCount;
            }

            @Override
            public Map<String, String> next() {
                TreeMap<String, String> cells = new TreeMap<String, String>();
                NodeList bodyRow = TestCaseTable.this.getCells(rows.elementAt(this.rowNumber++));
                for (int col = 0; col < headRow.size(); ++col) {
                    Node column = headRow.elementAt(col);
                    NodeList children = column.getChildren();
                    if (children == null) continue;
                    String key = children.asString().toLowerCase();
                    if (col < bodyRow.size()) {
                        Node cell = bodyRow.elementAt(col);
                        NodeList cellNodeList = cell.getChildren();
                        if (cellNodeList == null) {
                            cells.put(key, "");
                            continue;
                        }
                        String value = cellNodeList.asString();
                        cells.put(key, value);
                        NodeList links = TestCaseTable.this.getLinks(cell);
                        if (links.size() <= 0) continue;
                        LinkTag link = (LinkTag)links.elementAt(0);
                        cells.put(key + "_link", link.getLink());
                        continue;
                    }
                    cells.put(key, "");
                }
                return cells;
            }

            @Override
            public void remove() {
            }
        };
    }

    private static NodeList getRows(TableTag tableNode) {
        return tableNode.getChildren().extractAllNodesThatMatch((NodeFilter)new NodeClassFilter(TableRow.class));
    }

    private NodeList getCells(Node rowNode) {
        return rowNode.getChildren().extractAllNodesThatMatch((NodeFilter)new NodeClassFilter(TableColumn.class));
    }

    private NodeList getLinks(Node rowNode) {
        return rowNode.getChildren().extractAllNodesThatMatch((NodeFilter)new NodeClassFilter(LinkTag.class));
    }

    private static <T> List<T> asList(Iterable<T> iterable) {
        LinkedList<T> list = new LinkedList<T>();
        Iterator<T> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }
}

