/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.fitnesse;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PageSummary {
    private final String pageName;
    private final Set<String> tags;
    private final Map<String, String> extraProperties;
    private final String eventType;

    public PageSummary(String pageName, Set<String> tags, String eventType) {
        this(pageName, tags, Collections.emptyMap(), eventType);
    }

    public PageSummary(String pageName, Set<String> tags, Map<String, String> extraProperties, String eventType) {
        this.pageName = pageName;
        this.tags = tags;
        this.extraProperties = extraProperties;
        this.eventType = eventType;
    }

    public String getPageName() {
        return this.pageName;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public Map<String, String> getExtraProperties() {
        return this.extraProperties;
    }

    public int hashCode() {
        return this.pageName.hashCode() ^ this.tags.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof PageSummary)) {
            return false;
        }
        PageSummary other = (PageSummary)o;
        return other.pageName.equals(this.pageName) && other.tags.equals(this.tags);
    }

    public String toString() {
        JSONObject obj = new JSONObject();
        try {
            for (Map.Entry<String, String> kv : this.extraProperties.entrySet()) {
                obj.putOpt(kv.getKey(), (Object)kv.getValue());
            }
            obj.put("type", (Object)this.eventType);
            obj.put("pageName", (Object)this.pageName);
            obj.put("tags", (Object)new JSONArray(this.tags));
        }
        catch (JSONException e) {
            throw new RuntimeException("Can not make JSON", e);
        }
        return obj.toString();
    }
}

