/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.fitnesse;

import com.xebialabs.xltest.fitnesse.Feedback;
import com.xebialabs.xltest.fitnesse.FeedbackEventPrinter;
import com.xebialabs.xltest.fitnesse.PageSummary;
import com.xebialabs.xltest.fitnesse.TestCaseTable;
import fitnesse.http.MockRequest;
import fitnesse.http.Request;
import fitnesse.responders.run.SuiteResponder;
import fitnesse.testrunner.SuiteContentsFinder;
import fitnesse.testrunner.SuiteFilter;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.fs.FileSystemPage;
import fitnesse.wiki.fs.FileSystemPageFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;

public class WikiPageExtractor {
    private static final Logger LOG = Logger.getLogger(WikiPageExtractor.class.getName());
    public static final String PAGE_NAME_TABLE_COLUMN_NAME = "id_link";
    private final Feedback feedback;
    private String workingDir = ".";
    private String fitNesseRootDir = "FitNesseRoot";

    public WikiPageExtractor(Feedback feedback) {
        this.feedback = feedback;
    }

    public WikiPageExtractor withWorkingDir(String workingDir) {
        this.workingDir = workingDir;
        return this;
    }

    public WikiPageExtractor withFitNesseRootDir(String fitNesseRootDir) {
        this.fitNesseRootDir = fitNesseRootDir;
        return this;
    }

    public void tellMeAboutSuite(String suitePath, String filterOptions, String eventType) {
        Request request = this.makeRequest(suitePath, filterOptions);
        FileSystemPage root = new FileSystemPageFactory().makeRootPage(this.workingDir, this.fitNesseRootDir);
        for (WikiPage page : this.findWikiPages(request, (WikiPage)root)) {
            String pageName = page.getPageCrawler().getFullPath().toString();
            this.feedback.found(new PageSummary(pageName, this.makeTags(page), this.makeExtraProperties(pageName, page), eventType));
        }
    }

    private LinkedList<WikiPage> findWikiPages(Request request, WikiPage root) {
        String suitePath = request.getResource();
        SuiteFilter filter = SuiteResponder.createSuiteFilter((Request)request, (String)suitePath);
        WikiPage suitePage = root.getPageCrawler().getPage(PathParser.parse((String)suitePath));
        SuiteContentsFinder suiteTestFinder = new SuiteContentsFinder(suitePage, filter, root);
        return suiteTestFinder.getAllPagesToRunForThisSuite();
    }

    private Request makeRequest(String suitePath, String filterOptions) {
        MockRequest request = new MockRequest();
        if (filterOptions != null) {
            request.parseRequestUri("/" + suitePath + "?" + filterOptions);
        } else {
            request.parseRequestUri("/" + suitePath);
        }
        return request;
    }

    private Map<String, String> makeExtraProperties(String pageName, WikiPage page) {
        if (page.isRoot()) {
            return Collections.emptyMap();
        }
        TestCaseTable table = TestCaseTable.fromPage(page);
        for (Map<String, String> row : table.asKeyValuePairs()) {
            if (!row.containsKey(PAGE_NAME_TABLE_COLUMN_NAME) || !pageName.equals(row.get(PAGE_NAME_TABLE_COLUMN_NAME))) continue;
            return row;
        }
        return this.makeExtraProperties(pageName, page.getParent());
    }

    private Set<String> makeTags(WikiPage page) {
        if (page.isRoot()) {
            return WikiPageExtractor.set(new String[0]);
        }
        String tags = page.getData().getAttribute("Suites");
        Set<String> tagSet = this.isNotBlank(tags) ? WikiPageExtractor.set(tags.split(",")) : WikiPageExtractor.set(new String[0]);
        tagSet.addAll(this.makeTags(page.getParent()));
        return tagSet;
    }

    public static Set<String> set(String ... tags) {
        TreeSet<String> tagSet = new TreeSet<String>();
        for (String tag : tags) {
            String trimmed = tag.trim();
            if ("".equals(trimmed)) continue;
            tagSet.add(trimmed);
        }
        return tagSet;
    }

    private boolean isNotBlank(String tags) {
        return tags != null && !"".equals(tags);
    }

    public static void main(String ... args) {
        String suiteName = args[0];
        String eventType = args[1];
        String filterOptions = args.length > 2 ? args[2] : null;
        String url = System.getenv("XLTEST_URL");
        LOG.info("Starting Wiki page extractor...");
        LOG.info("Suite: " + suiteName);
        LOG.info("Sending " + eventType + " events to " + url);
        try {
            WikiPageExtractor extractor = new WikiPageExtractor(new FeedbackEventPrinter(new URL(url)));
            extractor.tellMeAboutSuite(suiteName, filterOptions, eventType);
        }
        catch (MalformedURLException e) {
            LOG.severe("Invalid URL: " + url);
        }
    }
}

