/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.fitnesse;

import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class TestSummary {
    private final String pageName;
    private final Set<String> tags;
    private final long timestamp;
    private final long duration;
    private final int right;
    private final int wrong;
    private final int exceptions;
    private final String firstError;
    private final Map<String, String> pageProperties;

    public TestSummary(String pageName, Set<String> tags, long timestamp, long duration, int right, int wrong, int exceptions, String firstError, Map<String, String> pageProperties) {
        this.pageName = pageName;
        this.tags = tags;
        this.timestamp = timestamp;
        this.duration = duration;
        this.right = right;
        this.wrong = wrong;
        this.exceptions = exceptions;
        this.firstError = firstError;
        this.pageProperties = pageProperties;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.duration ^ this.duration >>> 32);
        result = 31 * result + this.exceptions;
        result = 31 * result + (this.pageName == null ? 0 : this.pageName.hashCode());
        result = 31 * result + (this.pageProperties == null ? 0 : this.pageProperties.hashCode());
        result = 31 * result + this.right;
        result = 31 * result + (this.tags == null ? 0 : this.tags.hashCode());
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + this.wrong;
        result = 31 * result + (this.firstError == null ? 0 : this.firstError.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TestSummary other = (TestSummary)obj;
        if (this.duration != other.duration) {
            return false;
        }
        if (this.exceptions != other.exceptions) {
            return false;
        }
        if (this.pageName == null ? other.pageName != null : !this.pageName.equals(other.pageName)) {
            return false;
        }
        if (this.pageProperties == null ? other.pageProperties != null : !this.pageProperties.equals(other.pageProperties)) {
            return false;
        }
        if (this.right != other.right) {
            return false;
        }
        if (this.tags == null ? other.tags != null : !this.tags.equals(other.tags)) {
            return false;
        }
        if (this.timestamp != other.timestamp) {
            return false;
        }
        if (this.wrong != other.wrong) {
            return false;
        }
        return !(this.firstError == null ? other.firstError != null : !this.firstError.equals(other.firstError));
    }

    public String toString() {
        JSONObject obj = new JSONObject();
        try {
            obj.put("type", (Object)"result");
            obj.put("pageName", (Object)this.pageName);
            obj.put("tags", this.tags);
            obj.put("timestamp", this.timestamp);
            obj.put("duration", this.duration);
            obj.put("right", this.right);
            obj.put("wrong", this.wrong);
            obj.put("exceptions", this.exceptions);
            JSONObject pagePropertiesAsJSON = new JSONObject();
            for (String pagePropertyName : this.pageProperties.keySet()) {
                pagePropertiesAsJSON.put(pagePropertyName, (Object)this.pageProperties.get(pagePropertyName));
            }
            obj.put("properties", (Object)pagePropertiesAsJSON);
            if (this.firstError != null) {
                obj.put("firstError", (Object)this.firstError);
            }
        }
        catch (JSONException e) {
            throw new RuntimeException("Can not make JSON", e);
        }
        return obj.toString();
    }
}

