/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.fitnesse;

import com.xebialabs.xltest.fitnesse.Feedback;
import com.xebialabs.xltest.fitnesse.FeedbackEventSender;
import com.xebialabs.xltest.fitnesse.TestCaseTable;
import com.xebialabs.xltest.fitnesse.TestSummary;
import fitnesse.reporting.history.ExecutionReport;
import fitnesse.reporting.history.PageHistory;
import fitnesse.reporting.history.SuiteExecutionReport;
import fitnesse.reporting.history.TestExecutionReport;
import fitnesse.reporting.history.TestHistory;
import fitnesse.reporting.history.TestResultRecord;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.fs.FileSystemPage;
import fitnesse.wiki.fs.FileSystemPageFactory;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import util.FileUtil;

public class PageHistoryExtractor {
    public static final String PAGE_NAME_TABLE_COLUMN_NAME = "id_link";
    private static final Logger LOG = Logger.getLogger(PageHistoryExtractor.class.getName());
    private final Feedback<TestSummary> feedback;

    public PageHistoryExtractor(Feedback<TestSummary> feedback) {
        this.feedback = feedback;
    }

    public void tellMeAboutSuite(String suiteName) throws Exception {
        File resultsDirectory = new File("./FitNesseRoot/files/testResults");
        SuiteExecutionReport suiteExecutionReport = (SuiteExecutionReport)this.readExecutionReport(resultsDirectory, suiteName);
        FileSystemPage root = new FileSystemPageFactory().makeRootPage(".", "FitNesseRoot");
        for (SuiteExecutionReport.PageHistoryReference reference : suiteExecutionReport.getPageHistoryReferences()) {
            WikiPage thePage = root.getPageCrawler().getPage(PathParser.parse((String)reference.getPageName()));
            Set<String> tags = this.makeTags(thePage);
            Map<String, String> extraProperties = this.makeExtraProperties(reference.getPageName(), thePage);
            String firstErrorMessage = this.findFirstErrorMessage(resultsDirectory, reference);
            this.feedback.found(new TestSummary(reference.getPageName(), tags, reference.getTime(), reference.getRunTimeInMillis(), reference.getTestSummary().getRight(), reference.getTestSummary().getWrong(), reference.getTestSummary().getExceptions(), firstErrorMessage, extraProperties));
        }
    }

    private Set<String> makeTags(WikiPage page) {
        if (page.isRoot()) {
            return PageHistoryExtractor.set(new String[0]);
        }
        String tags = page.getData().getAttribute("Suites");
        Set<String> tagSet = this.isNotBlank(tags) ? PageHistoryExtractor.set(tags.split(",")) : PageHistoryExtractor.set(new String[0]);
        tagSet.addAll(this.makeTags(page.getParent()));
        return tagSet;
    }

    private Map<String, String> makeExtraProperties(String pageName, WikiPage page) {
        if (page.isRoot()) {
            return Collections.emptyMap();
        }
        TestCaseTable table = TestCaseTable.fromPage(page);
        for (Map<String, String> row : table.asKeyValuePairs()) {
            if (!row.containsKey(PAGE_NAME_TABLE_COLUMN_NAME) || !pageName.equals(row.get(PAGE_NAME_TABLE_COLUMN_NAME))) continue;
            return row;
        }
        return this.makeExtraProperties(pageName, page.getParent());
    }

    private String findFirstErrorMessage(File resultsDirectory, SuiteExecutionReport.PageHistoryReference reference) throws Exception {
        TestExecutionReport testExecutionReport = (TestExecutionReport)this.readExecutionReport(resultsDirectory, reference.getPageName());
        TestExecutionReport.TestResult testResult = (TestExecutionReport.TestResult)testExecutionReport.getResults().get(0);
        for (TestExecutionReport.InstructionResult instructionResult : testResult.getInstructions()) {
            for (TestExecutionReport.Expectation expectation : instructionResult.getExpectations()) {
                if ("fail".equals(expectation.getStatus())) {
                    return String.format("Actual: '%s'; Expected: '%s'", expectation.getActual(), expectation.getExpected());
                }
                if (!"error".equals(expectation.getStatus())) continue;
                return expectation.getEvaluationMessage();
            }
        }
        return null;
    }

    private <T extends ExecutionReport> T readExecutionReport(File resultsDirectory, String pageName) throws Exception {
        TestHistory history = new TestHistory();
        history.readPageHistoryDirectory(resultsDirectory, pageName);
        PageHistory pageHistory = history.getPageHistory(pageName);
        TestResultRecord testResultRecord = pageHistory.get(pageHistory.getLatestDate());
        return (T)ExecutionReport.makeReport((String)FileUtil.getFileContent((File)testResultRecord.getFile()));
    }

    public static Set<String> set(String ... tags) {
        TreeSet<String> tagSet = new TreeSet<String>();
        for (String tag : tags) {
            String trimmed = tag.trim();
            if ("".equals(trimmed)) continue;
            tagSet.add(trimmed);
        }
        return tagSet;
    }

    private boolean isNotBlank(String tags) {
        return tags != null && !"".equals(tags);
    }

    public static void main(String ... args) {
        String suiteName = args[0];
        String url = System.getenv("XLTEST_URL");
        LOG.info("Starting Page history extractor...");
        LOG.info("Suite: " + suiteName);
        LOG.info("Sending events to " + url);
        try {
            PageHistoryExtractor extractor = new PageHistoryExtractor(new FeedbackEventSender(new URL(url)));
            extractor.tellMeAboutSuite(suiteName);
        }
        catch (MalformedURLException e) {
            LOG.severe("Invalid URL: " + url);
        }
        catch (Exception e) {
            LOG.severe("Could not extract page history: " + e);
        }
    }
}

