package com.xebialabs.xltest.elasticsearch;

import static org.elasticsearch.common.xcontent.XContentFactory.jsonBuilder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.settings.ImmutableSettings.Builder;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchBooter {
	
	private static final Logger LOG = LoggerFactory.getLogger(ElasticSearchBooter.class);
	
	public volatile Client client;
	
	public ElasticSearchBooter() {
		boot();
	}

	private void boot() {
		
		final ClassLoader classLoader = this.getClass().getClassLoader();

		final Thread thread = new Thread(new Runnable() {
			@Override
			public void run() {
				try {
                    // Increase log level, so we do not get all sorts of logging on the console.
                    java.util.logging.Logger.getLogger("org.elasticsearch").setLevel(Level.SEVERE);

                    Builder nodeSettings = NodeBuilder.nodeBuilder().settings();
                    nodeSettings.put("network.host", "127.0.0.1");
                    nodeSettings.put("cluster.name", "elasticsearch_xltest");
                    nodeSettings.put("index.number_of_shards", 1);
                    nodeSettings.put("index.number_of_replicas", 0);
                    nodeSettings.put("node.name", "XL Test");
                    nodeSettings.put("http.enabled", "true".equals(System.getenv("DEV_MODE")));

                    Node node = NodeBuilder.nodeBuilder().settings(nodeSettings.build()).node();
					client = node.client();
					
					LOG.info("ElasticSearch up and running");
				} catch (Throwable tr) {
					throw new RuntimeException(tr);
				}

			}

		});
		thread.setContextClassLoader(classLoader);
		thread.start();
	}
	
	public void insert(String type, String json) {
		client.prepareIndex("xltest", type).setSource(json).execute().actionGet();
	}
	
	public List<String> query(String query) throws IOException {
		List<String> all = new ArrayList<String>();
		QueryStringQueryBuilder b = QueryBuilders.queryString(query);
		SearchResponse response = client.prepareSearch("xltest")
		        .setQuery(b)
		        .addSort("timestamp", SortOrder.ASC)
		        .setFrom(0).setSize(100000)
		        .execute()
		        .actionGet();
		SearchHits hits = response.getHits();
		for (SearchHit hit :hits) {
			all.add(hit.sourceAsString());
		}
		return all;
	}

}
