<#macro TIMEOUTLINE event>
      <tr>
        <#assign application = event.get('application')>
        <#assign applicationPackage = event.get('applicationPackage')>
        <#assign usecase = event.get('usecase')>
        <#assign ntests = event.get('ntests')>
        <#if event.hasProperty('buildNumber')>
          <#assign buildNumber = event.get('buildNumber')>
        <#else>
          <#assign buildNumber = "NoBuildNumberFoundInJobStatusEvent" >
        </#if>
        <#if event.hasProperty('buildUrl')>
          <#assign jenkins_job_url = event.get('buildUrl') >
        </#if>
        <#assign pageName = event.get('suiteName') >
        <td><a href="http://localhost:8084/FrontPage.${application}">${application}</a></td>
        <td><a href="http://localhost:8084/FrontPage.${application}.${applicationPackage}">${applicationPackage}</a></td>
        <td><a href="http://localhost:8084/FrontPage.${application}.${applicationPackage}.${usecase}">${usecase}</a></td>
        <td> ${ntests} tests</td>
        <td></td>
        <td>
          <#if event.hasProperty('team')>
            ${event.get('team')}
          </#if>
        </td>
        <td></td>
        <td>
          <#if event.hasProperty('browser')>
            ${event.get('browser')}
          </#if>
        </td>
        <td>
          <#if event.hasProperty('run_time')>
            <#if jenkins_job_url??>
              <a href="${jenkins_job_url}/Fitnesse_Report/${pageName}.html">${event.get('run_time')?number_to_datetime}</a>
            <#else>
          	  ${event.get('run_time')?number_to_datetime}
          	</#if>
          </#if>
        </td>
        <td></td>
      </tr>
</#macro>

<#macro RESULTTYPE result title>
<tr>
  <th colspan="10"><h3>${title}</h3></th>
</tr>
<tr>
  <th>Application</th><th>Use case Suite</th><th>Use case</th><th>Test Case</th><th>Priority</th><th>Team</th><th>Issue</th><th>Browser</th><th>Runtime</th><th>Info</th>
</tr>
<#assign events = dashboardCombinationCreator.getResultEventsFromDashboardCombination(combination, result, 'name')>
<#list events as event>
  <#if event.type == 'functionalResult'>
    <tr>
      <#assign application = event.get('application')>
      <#assign applicationPackage = event.get('applicationPackage')>
      <#assign usecase = event.get('usecase')>
      <#assign testcase = event.get('testcase')>
      <#assign buildNumber = event.get('buildNumber') >
      <#if event.hasProperty('buildUrl')>
        <#assign jenkins_job_url = event.get('buildUrl') >
      </#if>
      <#assign pageName = event.get('name') >
      <td><a href="http://localhost:8084/FrontPage.${application}">${application}</a></td>
      <td><a href="http://localhost:8084/FrontPage.${application}.${applicationPackage}">${applicationPackage}</a></td>
      <td><a href="http://localhost:8084/FrontPage.${application}.${applicationPackage}.${usecase}">${usecase}</a></td>
      <td><a href="http://localhost:8084/FrontPage.${application}.${applicationPackage}.${usecase}.${testcase}">${testcase}</a></td>
      <td>
        <#if event.hasProperty('priority')>
          ${event.get('priority')}
        </#if>
      </td>
      <td>
        <#if event.hasProperty('team')>
          ${event.get('team')}
        </#if>
      </td>
      <td>
        <#if event.hasProperty('issue')>
          <a href="${event.get('issue')}">${event.get('issue')}</a>
        </#if>
      </td>
      <td>
        <#if event.hasProperty('browser')>
          ${event.get('browser')}
        </#if>
      </td>
      <td style="white-space:nowrap;">
        <#if event.hasProperty('run_time')>
            <#if jenkins_job_url??>
              <a href="${jenkins_job_url}/Fitnesse_Report/${pageName}.html">${event.get('run_time')?number_to_datetime}</a>
            <#else>
          	  ${event.get('run_time')?number_to_datetime}
          	</#if>
        </#if>
      </td>
      <td>
        <#if jenkins_job_url??>
          <a href="${jenkins_job_url}artifact/FitNesseRoot/files/testResults/screenshots/FrontPage.${application}.${applicationPackage}.${usecase}/">sc</a>
        </#if>
      </td>
    </tr>
    <tr class="secondary">
      <td colspan="10">
        <#if event.hasProperty('testcasedescription')>
          <div>${event.get('testcasedescription')}</div>
        </#if>
        <#if event.hasProperty('firstError')>
          <div style="color:red">${event.get('firstError')}</div>
        </#if>
        <#if queryParameters?size &gt; 3>
          <#assign correspondingOlderEvents = testRun.getCorrespondingEventsFromOlderRuns(event, this.getProperty('maxRunsInHistory'), 'type', 'name')>
          <#assign thisResult = event.get('result')!"">
          <#assign prevResult = thisResult>
          <#assign nChanges = 0>
          <#assign total = 1>
          <#list correspondingOlderEvents as olderEvent>
            <#assign oldResult = olderEvent.get('result')!"">
            <#if oldResult != prevResult>
              <#assign prevResult = oldResult>
              <#assign nChanges = nChanges + 1>
            </#if>
            <#assign total = total + 1>
          </#list>
          <#assign flaky = ((nChanges / total) * 100)?floor >
          <br/>
          <table>
            <tr>
              <td><div title="Flakiness is the number of different test results over time divided by the number of test results">${flaky}% flaky</div></td>
              <#assign uri = testRun.getProperty('uri')>
              <#assign base = uri?substring(0, uri?index_of("/test/"))>
              <#list correspondingOlderEvents as olderEvent>
                <#assign oldResult = olderEvent.get('result')!"">
                <#assign report_id = this.getId() >
                <#assign runId = olderEvent.get('runId') >
                <#assign applicationPackage = olderEvent.get('applicationPackage')!"" >
                <#assign team = olderEvent.get('team')!"" >
                <#assign application = olderEvent.get('application')!"" >
                <#assign usecase = olderEvent.get('usecase')!"" >
                <#assign runDay = this.thisDay(olderEvent.get('timestamp')) >
                <#if oldResult == "PASSED">
                  <td bgcolor="green">
                <#else>
                  <td bgcolor="red">
                </#if>
                  <a href="${base}/#/reports/${runId}/${report_id}?applicationPackage=${applicationPackage}&team=${team}&application=${application}&usecase=${usecase}">${runDay}</a>
                </td>
              </#list>
            </tr>
          </table>
        </#if>
      </td>
    </tr>
  </#if>
</#list>
<#if result == "NOT RUN">
  <tr>
    <th colspan="10"><h3>Timeouts</h3></th>
  </tr>
  <tr>
    <th>Application</th><th>Use case Suite</th><th>Use case</th><th>Test Case</th><th>Priority</th><th>Team</th><th>Issue</th><th>Browser</th><th>Runtime</th><th>Info</th>
  </tr>
  <#assign events = dashboardCombinationCreator.getJobStatusEventsFromDashboardCombination(combination, "jobStatus")>
  <#list events as event>
    <#if event.type == 'jobStatus'>
      <@TIMEOUTLINE event = event/>
    </#if>
  </#list>
  <#assign events = dashboardCombinationCreator.getNonAppliedTimeoutsNotHavingNewerResultsFromDashboardCombination(combination)>
  <#list events as event>
    <#if event.type == 'jobStatus'>
      <@TIMEOUTLINE event = event/>
    </#if>
  </#list>
</#if>
</#macro>



<#if (queryParameters?size == 0)>
  <#assign reportId = this.getId() >
  <#assign parameters = "">
  <#if testRun.hasProperty('browser') >
    <#assign parameters = parameters + "Browser: " + testRun.getProperty('browser') + " ">
  </#if>
  <#if testRun.hasProperty('suiteFilter') >
    <#assign parameters = parameters + "SuiteFilter: " + testRun.getProperty('suiteFilter') + " ">
  </#if>
  <#assign nextDate = testRun.nextDate()!"">
  <#assign previousDate = testRun.previousDate()!"">
  <#assign environment = testRun.getProperty('environment')>
  <#assign uri = testRun.getProperty('uri')>
  <#assign rightLink = "?report=monitor&amp;date=" + nextDate +"&amp;environment=" + environment>
  <#assign leftLink = "?report=monitor&amp;date=" + previousDate +"&amp;environment=" + environment>
  <table width="100%">
    <tr width="100%">
      <td width="50%">
        <#if previousDate == "">
          No older runs
        <#else>
          <a href="${leftLink}">&lt;&lt;</a>
        </#if>
      </td>
      <td width="50%" align="right">
        <#if nextDate == "">
          No newer runs
        <#else>
          <a href="${rightLink}">&gt;&gt;</a>
        </#if>
      </td>
    </tr>
  </table>
<#else>
  <#assign combination = dashboardCombinationCreator.getDashboardCombination(testRun, queryParameters)>
  <table class="table two-rows">
    <tbody  bgcolor="white" fgcolor="black">
      <@RESULTTYPE result="FAILED" title="Failed"/>
      <@RESULTTYPE result="NOT RUN" title="Not Run"/>
      <@RESULTTYPE result="NOT_FOUND" title="No Results found"/>
      <@RESULTTYPE result="KNOWN ISSUE" title="Known Failed"/>
      <@RESULTTYPE result="PASSED" title="Passed"/>
    </tbody>
  </table>
</#if>
