

from urllib2 import quote

id = testRun.getTestRunId()

events = testRun.getEvents(queryParameters)

def firstXaxisInSequenceThatIsNotInQueryParameters(drilldownsequence, queryParameters):
    print 'drilldownsequence is a list', drilldownsequence
    print 'queryParameters is a map', queryParameters
    keys = queryParameters.keySet()
    for drilldown in drilldownsequence:
        if not keys.contains(drilldown):
            print 'xaxis computed to be', drilldown
            return drilldown, True
    print 'WARNING xaxis could not be computed'
    return drilldownsequence[-1], False

def makeOldQueryParameters(queryParameters):
    result = '&'.join(quote(k) + '=' + quote(v) for k, v in dict(queryParameters).iteritems())
    return result and (result + '&') or ''

drilldownsequence = self.getProperty('drilldownsequence')
xaxis, canDrillDown = firstXaxisInSequenceThatIsNotInQueryParameters(drilldownsequence, queryParameters)
drilldown = self.getProperty('drilldown')

if xaxis == 'team':
    rotation = 0
else:
    rotation = -45

oldQueryParameters = makeOldQueryParameters(queryParameters)
if drilldown:
    URL = '%s/%s?%s%s=' % (id, drilldown.id, oldQueryParameters, xaxis)
else:
    URL = ''

if events:
    passed = {}
    failed = {}
    known = {}
    notrun = {}
    timeout = {}
    for ev in events:
        if ev.type == 'functionalResult':
            p = ev.getProperties()
            x = p.get(xaxis)
            result = p.get('result')
            if x is None:
                continue
            if result == 'PASSED':
                passed.setdefault(x, []).append(1)
            elif result == 'KNOWN ISSUE':
                known.setdefault(x, []).append(1)
            elif result == 'NOT_FOUND':
                notrun.setdefault(x, []).append(1)
            else:
                failed.setdefault(x, []).append(1)
        elif ev.type == 'jobStatus' and ev.getProperties().get('reason') == 'timeout':
            ntests = ev.getProperties().get('ntests')
            if ntests is None:
                ntests = 0
            x = ev.getProperties().get(xaxis) or ('Unknown %s' % xaxis)
            timeout.setdefault(x, []).append(ntests)
        elif ev.type == 'jobStatus' and ev.getProperties().get('reason') == 'failure':
            ntests = ev.getProperties().get('ntests')
            if ntests is None:
                ntests = 0
            x = ev.getProperties().get(xaxis) or ('Unknown %s' % xaxis)
            notrun.setdefault(x, []).append(ntests)

    xs = sorted(set(failed.keys() + passed.keys() + known.keys() + notrun.keys() + timeout.keys()))

    def make_column_values(group_map, groups):
        return map(lambda t: group_map.has_key(t) and { 'y': sum(group_map[t]), 'url': URL and (URL + t) } or None, groups)

    passed = make_column_values(passed, xs)
    failed = make_column_values(failed, xs)
    known = make_column_values(known, xs)
    notrun = make_column_values(notrun, xs)
    timeout = make_column_values(timeout, xs)
    xs = map(lambda x: x[:20], xs)
    print xaxis.title(), xs


    resultHolder.setResult(
        {
            'chart': {
                'type': 'column',
                'animation': False
            },
            'title': {
                'text': 'Test result overview per %s' % xaxis
            },
            'xAxis': {
                'categories': xs,
                'labels': {
                    'rotation': rotation,
                }
            },
            'yAxis': {
                'min': 0,
                'title': {
                    'text': 'Total tests'
                },
                'stackLabels': {
                    'enabled': True
                },
                'minTickInterval': 1
            },
            'colors': ['#ABD718', '#D31155', '#055F75', '#E36C16', '#009190'],
            'plotOptions': {
                'column': {
                    'animation': False,
                    'cursor': 'pointer',
                    'stacking': 'normal',
                    'dataLabels': {
                        'enabled': True,
                        'color': 'white'
                    }
                },
                'series': canDrillDown and {
                    'point': {
                        'events': {
                            'click': 'url'
                        }
                    }
                } or None
            },
            'credits': {
                'enabled': False
            },
            "series": [{
                           "name": "Passed",
                           "data": passed
                       },
                       {
                           "name": "Failed",
                           "data": failed
                       },
                       {
                           "name": "Not run",
                           "data": notrun
                       },
                       {
                           "name": "Known Issue",
                           "data": known
                       },
                       {
                           "name": "Timeout",
                           "data": timeout
                       }]
        })
