# self is an instance of Report, 'repository' is the JCR repo and 'testRun' contains info about the run.
# pass the result into 'resultholder' like this: resultHolder.setResult({ 'success': success })

from java.util import Date
import operator
from java.lang import IllegalArgumentException
from urllib2 import quote
from com.xebialabs.xltest.bol import DashboardCombinationCreator

def nextDrilldownLevel(drilldownsequence, queryParameters):
    keys = queryParameters.keySet()
    for drilldown in drilldownsequence:
        if not keys.contains(drilldown):
            return drilldown, True
    return drilldownsequence[-1], False

def makeDrilldownUrl(xaxis):
    drilldown = self.getProperty('drilldown')
    queryStr = '&'.join(quote(k) + '=' + quote(v) for k, v in dict(queryParameters).iteritems())
    queryStr = queryStr and (queryStr + '&') or ''
    if drilldown:
        return '%s/%s?%s%s=' % (id, drilldown.id, queryStr, xaxis)
    else:
        return ''


def get_environment(testRun):
    'Not all events have an environment property. Implement a default'
    try:
        return testRun.getProperty('environment')
    except IllegalArgumentException:
        return "DEVELOP"


id = testRun.getTestRunId()
environment = get_environment(testRun)
startTime = testRun.startTime
drilldownsequence = self.getProperty('drilldownsequence')
xaxis, canDrillDown = nextDrilldownLevel(drilldownsequence, queryParameters)

combination = DashboardCombinationCreator().getDashboardCombination(testRun, queryParameters)
event_map = dict(combination.getEventMap())
timeouts = combination.getTimeouts()
failures = combination.getFailures()
applied_timeouts = combination.getAppliedTimeouts()
oldTimeoutsThatNowHaveAResult = combination.getOldTimeoutsThatNowHaveAResult()

# Okay, at this point event_map is a map[page name -> event].

if event_map:
    passed = []
    failed = []
    known = []
    notfound = []
    timeout = []
    for ev in event_map.itervalues():
        x = ev.get(xaxis)
        if x and ev.type == 'functionalResult':
            result = ev.get('result')
            if x is None:
                continue
            if result == 'PASSED':
                passed.append(1)
            elif result == 'KNOWN ISSUE':
                known.append(1)
            elif result == 'NOT_FOUND':
                notfound.append(1)
            else:
                failed.append(1)
        elif x and ev.type == 'jobStatus' and ev.getProperties().get('reason') == 'timeout':
            # Add one for each event that has been overridden by a timeout
            timeout.setdefault(x, []).append(1)
        elif x and ev.type == 'jobStatus' and ev.getProperties().get('reason') == 'failure':
            notfound.setdefault(x, []).append(1)

    # Also report on timeouts for which no events have been reported at all. Those need to be processed separately.
    for to in timeouts:
        if to in applied_timeouts or to in oldTimeoutsThatNowHaveAResult:
            continue
        x = to.get(xaxis)
        if x:
            ntests = to.get('ntests')
            if ntests is None:
                ntests = 0
            timeout.append(ntests)

    for f in failures:
        if f in applied_timeouts or f in oldTimeoutsThatNowHaveAResult:
            continue
        x = f.get(xaxis)
        if x:
            ntests = f.get('ntests')
            if ntests is None:
                ntests = 0
            notfound.append(ntests)

    resultHolder.setResult(
        {
            'chart': {
                'type': 'pie',
                'plotBackgroundColor': None,
                'plotBorderWidth': None,
                'plotShadow': False
            },
            'title': {
                'text': 'Test count',
            },
            'tooltip': {
                'pointFormat': '{series.name}: <b>{point.percentage:.1f}%</b>'
            },
            'legend': {
                'itemHoverStyle': {
                    'color': '#FFF'
                },
                'itemHiddenStyle': {
                    'color': '#606063'
                }
            },
            'credits': {
                'enabled': False
            },
            'colors': ['#ABD718', '#D31155', '#055F75', '#E36C16', '#009190'],
            'plotOptions': {
                'pie': {
                    'allowPointSelect': True,
                    'cursor': 'pointer',
                    'dataLabels': {
                        'enabled': True,
                        'format': '{y}'
                    },
                    'showInLegend': 'True',
                    'animation': False
                }
            },
            'series': [{
                           'data': [
                               ['Passed', sum(filter(None, passed))],
                               ['Failed', sum(filter(None, failed))],
                               ['No Results Found', sum(filter(None, notfound))],
                               ['Known Issue', sum(filter(None, known))],
                               ['Timeout', sum(filter(None, timeout))]
                           ]
                       }]
        })

