/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.bol;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.xltest.domain.TestRun;
import com.xebialabs.xltest.domain.TestSpecification;
import com.xebialabs.xltest.repository.TestRunsRepository;
import java.io.IOException;
import java.net.URI;
import java.util.UUID;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
@Path(value="/rerun")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class RerunTestController {
    private static final Logger LOG = LoggerFactory.getLogger(RerunTestController.class);
    private final RepositoryService repository;
    private final TestRunsRepository testRunsRepository;

    @Autowired
    public RerunTestController(RepositoryService repository, TestRunsRepository testRunsRepository) {
        this.repository = repository;
        this.testRunsRepository = testRunsRepository;
    }

    @GET
    @Path(value="{testRunId:[\\w-]+}/{suite:.+}")
    public Response rerunSlice(@PathParam(value="testRunId") String testRunId, @PathParam(value="suite") String suite, @HeaderParam(value="xltest-base") String xlTestBase, @Context UriInfo uriInfo) throws IOException, InterruptedException {
        LOG.info("Attempting to re-run suite {} that was part of test run {}", (Object)suite, (Object)testRunId);
        TestSpecification testRun = new TestSpecification();
        String taskId = this.fireTest(testRun, xlTestBase, uriInfo);
        URI location = URI.create("#/testruns/" + taskId);
        return Response.temporaryRedirect((URI)location).build();
    }

    public String fireTest(TestSpecification testRun, String xlTestBase, UriInfo uriInfo) {
        URI xlTestBaseUri = xlTestBase != null ? URI.create(xlTestBase + "/test") : uriInfo.getAbsolutePath();
        return "";
    }

    private TestRun findOldRun(String testRunId) {
        return this.testRunsRepository.getTestRun(UUID.fromString(testRunId));
    }

    private TestSpecification findAndCreateIfNecessary(TestRun oldRun, String suite) {
        TestSpecification systemSliceRerun;
        String id = "Configuration/TestSetDefinitions/systemSliceRerun";
        try {
            systemSliceRerun = (TestSpecification)this.repository.read(id);
        }
        catch (NotFoundException nfe) {
            Type bolSlice = Type.valueOf((String)"bol.SlicedFitNesseSubSet");
            systemSliceRerun = (TestSpecification)bolSlice.getDescriptor().newInstance(id);
            systemSliceRerun.setProperty("parent", (Object)oldRun.getTestSpecificationName());
            this.repository.create((ConfigurationItem[])new TestSpecification[]{systemSliceRerun});
        }
        systemSliceRerun.setProperty("suiteName", (Object)suite);
        return systemSliceRerun;
    }
}

