/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.bol;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.xltest.bol.DashboardCombination;
import com.xebialabs.xltest.domain.Event;
import com.xebialabs.xltest.domain.TestRun;
import com.xebialabs.xltest.repository.TestRunsRepository;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;

public class DashboardCombinationCreator {
    private DashboardCombination.Builder builder;
    TestRunsRepository testRunsRepository;

    public DashboardCombinationCreator(TestRunsRepository testRunsRepository) {
        this.testRunsRepository = testRunsRepository;
    }

    public DashboardCombination getDashboardCombination(TestRun testRun, Map queryParameters) {
        return this.getDashboardCombination(testRun, queryParameters, false);
    }

    public DashboardCombination getDashboardCombination(TestRun testRun, Map queryParameters, boolean includeDates) {
        Date startTime = DateUtils.truncate((Date)testRun.getStartTime(), (int)5);
        Date endTime = DateUtils.addDays((Date)startTime, (int)1);
        List<Event> finished_events = this.getEvents(testRun, queryParameters, startTime, endTime);
        HashSet<String> runIds = new HashSet<String>();
        for (Event finishEvent : finished_events) {
            runIds.add(finishEvent.getTestRunId().toString());
        }
        ArrayList<Event> result_events = new ArrayList<Event>();
        HashMap<String, Object> eventProperties = new HashMap<String, Object>();
        eventProperties.put("type", "result");
        this.copyParameter(eventProperties, queryParameters, "team");
        List eventsInRunInTimeframe = this.testRunsRepository.getEventsBetween(startTime.getTime(), endTime.getTime(), eventProperties);
        for (Event event : eventsInRunInTimeframe) {
            if (!this.matchingQueryParameters(event, queryParameters)) continue;
            result_events.add(event);
        }
        ArrayList<Event> timeoutsAndFailures = new ArrayList<Event>();
        for (Event finishEvent : finished_events) {
            if (this.isSuccessEvent(finishEvent) || !this.matchingQueryParameters(finishEvent, queryParameters)) continue;
            timeoutsAndFailures.add(finishEvent);
        }
        this.builder = DashboardCombination.builder().setEvents(this.aggregateResults(result_events, timeoutsAndFailures));
        if (includeDates) {
            this.builder.setPreviousDate(this.determineDate(startTime, -1, testRun, queryParameters)).setNextDate(this.determineDate(startTime, 1, testRun, queryParameters));
        }
        return this.builder.build();
    }

    private List<Event> getEvents(TestRun testRun, Map queryParameters, Date startTime, Date endTime) {
        HashMap<String, Object> eventProperties = new HashMap<String, Object>();
        eventProperties.put("type", "jobStatus");
        eventProperties.put("status", "finished");
        this.copyParameter(eventProperties, queryParameters, "team");
        return this.testRunsRepository.getEventsBetween(startTime.getTime(), endTime.getTime(), eventProperties);
    }

    private String determineDate(Date date, int i, TestRun testRun, Map queryParameters) {
        Date newDate = date;
        Date twoWeeksEarlier = DateUtils.addWeeks((Date)date, (int)-2);
        Date twoWeeksLater = DateUtils.addWeeks((Date)date, (int)2);
        while ((newDate = DateUtils.addDays((Date)newDate, (int)i)).before(twoWeeksLater) && newDate.after(twoWeeksEarlier) && this.getEvents(testRun, queryParameters, newDate, DateUtils.addDays((Date)newDate, (int)1)).size() == 0) {
        }
        if (newDate.before(twoWeeksLater) && newDate.after(twoWeeksEarlier)) {
            return DateFormatUtils.format((Date)newDate, (String)"yyyy-MM-dd");
        }
        return null;
    }

    private void copyParameter(Map<String, Object> eventProperties, Map queryParameters, String key) {
        if (queryParameters.containsKey(key)) {
            eventProperties.put(key, queryParameters.get(key));
        }
    }

    private boolean matchingQueryParameters(Event event, Map<String, Object> queryParameters) {
        boolean match = true;
        if (event.hasProperty("team") && queryParameters.containsKey("team")) {
            match &= event.get("team").equals(queryParameters.get("team"));
        }
        if (event.hasProperty("testset") && queryParameters.containsKey("testset")) {
            match &= event.get("testset").equals("FrontPage." + queryParameters.get("testset")) || ((String)event.get("testset")).startsWith("FrontPage." + queryParameters.get("testset") + ".");
        }
        return match;
    }

    private boolean isSuccessEvent(Event finishEvent) {
        return "success".equals(finishEvent.get("reason"));
    }

    private List<Event> aggregateResults(List<Event> events, List<Event> timeoutsAndFailures) {
        String key;
        HashMap<String, Event> agg = new HashMap<String, Event>();
        String keyAttr = "testset";
        block0: for (Event e : events) {
            if (!e.hasProperty(keyAttr)) continue;
            key = (String)e.get(keyAttr);
            Event other = (Event)agg.get(key);
            if (other == null || (Long)other.get("timestamp") < (Long)e.get("timestamp")) {
                agg.put(key, e);
            }
            for (Event to : timeoutsAndFailures) {
                if (!key.startsWith(to.get(keyAttr) + ".") || (Long)to.get("timestamp") <= (Long)e.get("timestamp")) continue;
                agg.put(key, to);
                continue block0;
            }
        }
        for (Event event : timeoutsAndFailures) {
            Map filteredKeys;
            if (!event.hasProperty(keyAttr) || (filteredKeys = Maps.filterKeys(agg, (Predicate)new Predicate<String>(key = (String)event.get(keyAttr)){
                final /* synthetic */ String val$key;
                {
                    this.val$key = string;
                }

                public boolean apply(String input) {
                    return input.startsWith(this.val$key + ".");
                }
            })).size() != 0) continue;
            agg.put(key, event);
        }
        return this.sortEvents(Lists.newArrayList((Iterable)Sets.newHashSet(agg.values())), keyAttr);
    }

    private List<Event> sortEvents(List<Event> events, final String sortingProperty) {
        ArrayList filteredEvents = Lists.newArrayList((Iterable)Iterables.filter(events, (Predicate)new Predicate<Event>(){

            public boolean apply(Event e) {
                return e.hasProperty(sortingProperty) && e.get(sortingProperty) instanceof Comparable;
            }
        }));
        Collections.sort(filteredEvents, new Comparator<Event>(){

            @Override
            public int compare(Event o1, Event o2) {
                String s1 = (String)o1.get(sortingProperty);
                String s2 = (String)o2.get(sortingProperty);
                return s1.compareTo(s2);
            }
        });
        return filteredEvents;
    }
}

