/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.bol;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.xebialabs.xltest.domain.Event;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DashboardCombination {
    private static Logger LOG = LoggerFactory.getLogger(DashboardCombination.class);
    private final List<Event> events;
    private final String previousDate;
    private final String nextDate;

    private DashboardCombination(List<Event> events, String previousDate, String nextDate) {
        this.events = events;
        this.previousDate = previousDate;
        this.nextDate = nextDate;
    }

    public List<Event> getEvents() {
        return this.events;
    }

    public List<Event> getEvents(final String type, final String key, final String result) {
        ArrayList results = Lists.newArrayList((Iterable)Iterables.filter(this.events, (Predicate)new Predicate<Event>(){

            public boolean apply(Event input) {
                return input.getType().equals(type) && input.hasProperty(key) && input.get(key).equals(result);
            }
        }));
        LOG.debug("getEvent({}, {}, {}) = #{}", new Object[]{type, key, result, results.size()});
        return results;
    }

    public String getPreviousDate() {
        return this.previousDate;
    }

    public String getNextDate() {
        return this.nextDate;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        List<Event> events;
        String previousDate;
        String nextDate;

        public Builder setEvents(List<Event> events) {
            this.events = events;
            return this;
        }

        public Builder setPreviousDate(String previousDate) {
            this.previousDate = previousDate;
            return this;
        }

        public Builder setNextDate(String nextDate) {
            this.nextDate = nextDate;
            return this;
        }

        public DashboardCombination build() {
            return new DashboardCombination(this.events, this.previousDate, this.nextDate);
        }
    }
}

