from com.xebialabs.xltest.plan import ParallelPlan, SerialPlan, TestPlan
from com.xebialabs.overthere import CmdLine
from com.xebialabs.deployit.plugin.api.reflect import DescriptorRegistry, Type
from org.slf4j import LoggerFactory
from subprocess import call
from subprocess import check_call
from xml.etree import ElementTree
import shutil
import os, re
import xml.etree
import xml.parsers.expat

LOG = LoggerFactory.getLogger("Slice FitNesse")
WIKI_WORD = re.compile(r'^[A-Z][a-z0-9]+(?:[A-Z][a-z0-9]*)+$')

FitNesseSlice = DescriptorRegistry.getDescriptor(Type.valueOf("bol.FitNesseSlice")).newInstance

timeout = self.getProperty('timeoutPerSlice')
longtimeout = self.getProperty('longtimeoutPerSlice')
repositoryType = self.getProperty('repositoryType')
scmUrl = self.getProperty('repositoryUrl')
branchOrRevision = self.getProperty('branch')
workDir = self.getProperty('workingDir')
projectDir = self.getProperty('projectDir')
suiteName = self.getProperty('suiteName')
blacklistfile = self.getProperty('blacklistfile')
longtimeoutfile = self.getProperty('longtimeoutfile')
browser = self.getProperty('browser')
suiteFilter = self.getProperty('suiteFilter')

suitePath = os.path.join(*([workDir, projectDir, 'FitNesseRoot'] + suiteName.split('.')))

LOG.info("Updating working tree {}", suitePath)

if not os.path.exists(workDir):
    check_call(["mkdir", "-p", workDir])
    print "Created fresh dir:", workDir, "Now checking out"

if repositoryType.lower() == "svn":
    check_call(["svn", "co", "-q", scmUrl + os.sep + branchOrRevision, workDir])
elif repositoryType.lower() == "git":
    if not os.path.exists(os.path.join(*([workDir, projectDir, "FitNesseRoot"]))):
        check_call(["git", "clone", "-q", scmUrl, "--branch", branchOrRevision, workDir])
    else:
        os.chdir(workDir)
        check_call(["git", "checkout", "-q", branchOrRevision])
        check_call(["git", "pull", "-q"])
else:
    raise RuntimeError("Invalid repositoryType " + repositoryType)

LOG.info("Updating working tree {} ... done", suitePath)

LOG.info("Scanning working tree for test suites")

def blacklisted(pages):
    full_page_name = '.'.join(pages)
    return full_page_name in blacklisted_pages

def isValidPage(path, page_name):
    return WIKI_WORD.match(page_name) and os.path.isdir(os.path.join(path, page_name))

def getXmlElement(xmlFile, element):
    try:
        if os.path.exists(xmlFile):
            xml = ElementTree.parse(xmlFile)
            xmlRoot = xml.getroot();
            return xmlRoot.find(element);
    except:
        LOG.error("could not parse XML of {}", xmlFile)
    return None
    
def getPropertiesElement(path, element):
    return getXmlElement(os.path.join(path, 'properties.xml'), element)
    
def isSuite(path):
    return getPropertiesElement(path, 'Suite') is not None

def isTest(path):
    return getPropertiesElement(path, 'Test') is not None

def hasTag(path, tag):
    suites = getPropertiesElement(path, 'Suites')
    return suites is not None and suites.text is not None and tag in suites.text.lower()
    
def isNightlyOrDailyTest(path):
    return isTest(path) and (hasTag(path, 'nightly') or hasTag(path, 'daily'))

def hasSuites(workDir):
    for page_name in os.listdir(workDir):
        path = os.path.join(workDir, page_name)
        if isValidPage(workDir, page_name) and isSuite(path):
            return True
    return False
            
def hasTests(workDir):
    for page_name in os.listdir(workDir):
        path = os.path.join(workDir, page_name)
        if isValidPage(workDir, page_name) and isTest(path):
            return True
    return False
    
def find_test_suites(path, pages=()):
    if isSuite(path) or path == suitePath:
        if hasSuites(path):
            for page_name in os.listdir(path):
                if isValidPage(path, page_name):
                    for suite in find_test_suites(os.path.join(path, page_name), pages + (page_name,)): yield suite
        elif blacklisted(pages):
            LOG.info('NOT adding {} to plan as it is blacklisted', '.'.join(pages))
        elif hasTests(path):
            LOG.trace("adding {}", ".".join(pages))
            yield '.'.join(pages)

def make_plan(sliceName):
    full_path = '.'.join([suiteName, sliceName])
    tsd = FitNesseSlice(full_path)
    tsd.setProperty('suiteName', full_path)
    if sliceName in longtimeout_pages:
        LOG.info('Adding {} to plan. slice {} has a longtimeout', full_path, sliceName)
        tsd.setProperty('timeout', longtimeout)
    else:
        tsd.setProperty('timeout', timeout)
        LOG.info('Adding {} to plan. slice {} has a normal timeout', full_path, sliceName)
    tsd.setProperty('repositoryUrl', scmUrl)
    tsd.setProperty('branch', branchOrRevision)
    tsd.setProperty('browser', browser)
    if browser.lower() == 'iexplore':
        tsd.setProperty('webdriver', 'BrowserExtensions/IEDriverServer.exe')
    else:
        tsd.setProperty('label', 'fitnesse')
        tsd.setProperty('webdriver', '')
    return TestPlan(tsd, CmdLine().addArgument("./startSubTestRun.sh").addArgument(full_path))

def readFileWithPages(filename):
    if os.path.exists(filename):
        f = open(filename)
        pages = f.readlines()
        f.close()
        return [l.strip('\n\r') for l in pages]
    return ()

blacklisted_pages = readFileWithPages(blacklistfile)
print 'blacklisted pages', blacklisted_pages

longtimeout_pages = readFileWithPages(longtimeoutfile)
print 'longtimeout pages', longtimeout_pages

LOG.info('browser: {}', browser)
LOG.info('suiteFilter: {}', suiteFilter)

# Make it a set, so duplicates from find_test_suites() are eliminated
testSuites = set(find_test_suites(str(suitePath)))
LOG.info("found #{} of testsuites", len(testSuites))
LOG.info("executing testsuites:\n{}", testSuites)

plans = [make_plan(s) for s in set(testSuites)]
resultHolder.setResult(ParallelPlan(plans))
