<#macro STATUS reason title>
    <#assign shouldPrintHeader = true >

        <#if testRun.hasProperty('browser') >
          <#assign browser = testRun.getProperty('browser') >
        <#else>
          <#assign browser = "">
        </#if>
        <#if testRun.hasProperty('environment') >
          <#assign environment = testRun.getProperty('environment')>
        <#else>
          <#assign environment = "">
        </#if>
        <#list eventsFromThisRunMap?keys as suiteName>
          <#assign nStable = 0>
          <#assign nTimeout = 0>
          <#assign nUnstable = 0>
          <#assign nOther = 0>
          <#assign totalStableDuration = 0>
          <#assign totalTimeoutDuration = 0>
          <#assign totalUnstableDuration = 0>
          <#assign totalOtherDuration = 0>
          <#assign events = eventsFromThisRunMap[suiteName] >
          <#list events as finishedEventInCurrentRun>
            <#if finishedEventInCurrentRun.reason == reason>
              <#if finishedEventInCurrentRun.reason == "success">
                <#assign nStable = 1>
              <#elseif finishedEventInCurrentRun.reason == "timeout">
                <#assign nTimeout = nTimeout + 1>
              <#elseif finishedEventInCurrentRun.reason == "unstable">
                <#assign nUnstable = nUnstable + 1>
              <#else>
                <#assign nOther = nOther + 1>
              </#if>
              <#if shouldPrintHeader >
                <tr>
                  <th colspan="19"><h3>${title}</h3></th>
                </tr>
                <tr>
                  <th>Suitename</th>
                  <th>Browser</th>
                  <th>Environment</th>
                  <th>Built on</th>
                  <th>Duration</th>
                  <th>TO</th>
                  <th>Average Duration</th>
                  <th>Runs</th>
                  <th title="Percentage of runs that timed out">%T</th>
                  <th title="Percentage of runs that were successfull">%S</th>
                  <th title="Percentage of runs that were unstable">%US</th>
                  <th title="Percentage of runs that failed, or were aborted">%F</th>
                  <th title="Average duration of successfull runs">tS</th>
                  <th title="Average duration of unstable runs">tUS</th>
                  <th title="Average duration of failed, or aborted runs">tF</th>
                  <th></th>
                  <th></th>
                  <th></th>
                  <th></th>
                </tr>
                <#assign shouldPrintHeader = false >
              </#if>
              <#assign jenkinsUri = finishedEventInCurrentRun.jenkinsUri!"http://jenkinsUriPropertyNotFoundInFinishedJobStatusEvent">
              <#assign jobName = finishedEventInCurrentRun.jobName!"jobNamePropertyNotFoundInFinishedJobStatusEvent">
              <#assign buildNumber = finishedEventInCurrentRun.buildNumber!"buildNumberPropertyNotFoundInFinishedJobStatusEvent">
              <#assign builtOn = finishedEventInCurrentRun.slave!"slavePropertyNotFoundInFinishedJobStatusEvent">
              <#assign timeout = finishedEventInCurrentRun.timeout!"timeoutNotFoundInFinishedJobStatusEvent">
              <#assign duration = (finishedEventInCurrentRun.timestamp - finishedEventInCurrentRun.started) / 60000>
              <#assign durationsTotal = duration>
              <#if finishedEventInCurrentRun.reason == "success">
                <#assign totalStableDuration = duration>
              <#elseif finishedEventInCurrentRun.reason == "timeout">
                <#assign totalTimeoutDuration = duration>
              <#elseif finishedEventInCurrentRun.reason == "unstable">
                <#assign totalUnstableDuration = duration>
              <#else>
                <#assign totalOtherDuration = duration>
              </#if>
              <#assign numberOfDurations = 1>
              <#assign finishedEventsFromOtherRuns = eventsFromOtherRunsMap[suiteName]![] >
              <#list finishedEventsFromOtherRuns as event>
                <#assign oldDuration = (event.timestamp - event.started) / 60000>
                <#assign durationsTotal = durationsTotal + oldDuration>
                <#assign numberOfDurations = numberOfDurations + 1>
                <#if event.reason == "success">
                  <#assign nStable = nStable + 1>
                  <#assign totalStableDuration = totalStableDuration + oldDuration>
                <#elseif event.reason == "timeout">
                  <#assign nTimeout = nTimeout + 1>
                  <#assign totalTimeoutDuration = totalTimeoutDuration + oldDuration>
                <#elseif event.reason == "unstable">
                  <#assign nUnstable = nUnstable + 1>
                  <#assign totalUnstableDuration = totalUnstableDuration + oldDuration>
                <#else>
                  <#assign nOther = nOther + 1>
                  <#assign totalOtherDuration = totalOtherDuration + oldDuration>
                </#if>        
              </#list>
              <tr>
                <td><a href="${jenkinsUri}/job/${jobName}/${buildNumber}/">${suiteName}</a></td>
                <td>${browser}</td>
                <td>${environment}</td>
                <td>${builtOn}</td>
                <#assign durationInMinutes = duration?int>
                <#assign durationInSeconds = ((duration - durationInMinutes) * 60)?int>
                <td>${durationInMinutes}m${durationInSeconds}s</td>
                <td>${timeout}m</td>
                <#assign avg = durationsTotal / numberOfDurations>
                <#assign avgInMinutes = avg?int>
                <#assign avgInSeconds = ((avg - avgInMinutes) * 60)?int>
                <td>${avgInMinutes}m${avgInSeconds}s</td>
                <td>${numberOfDurations}</td>
                <#assign timeoutPercentage = ((nTimeout / numberOfDurations) * 100)?int>
                <#assign stablePercentage = ((nStable / numberOfDurations) * 100)?int>
                <#assign unStablePercentage = ((nUnstable / numberOfDurations) * 100)?int>
                <#assign otherPercentage = ((nOther / numberOfDurations) * 100)?int>
                <td>${timeoutPercentage}</td>
                <td>${stablePercentage}</td>
                <td>${unStablePercentage}</td>
                <td>${otherPercentage}</td>
                <#if (nStable > 0)>
                  <#assign avgStableDuration = totalStableDuration / nStable>
                  <#assign avgStableDurationInMinutes = avgStableDuration?int>
                  <#assign avgStableDurationInSeconds = ((avgStableDuration - avgStableDurationInMinutes) * 60)?int>
                  <td>${avgStableDurationInMinutes}m${avgStableDurationInSeconds}s</td>
                <#else>
                  <td>?</td>
                </#if>
                <#if (nUnstable > 0)>
                  <#assign avgUnStableDuration = totalUnStableDuration / nUnstable>
                  <#assign avgUnStableDurationInMinutes = avgUnStableDuration?int>
                  <#assign avgUnStableDurationInSeconds = ((avgUnStableDuration - avgUnStableDurationInMinutes) * 60)?int>
                  <td>${avgUnStableDurationInMinutes}m${avgUnStableDurationInSeconds}s</td>
                <#else>
                  <td>?</td>
                </#if>
                <#if (nOther > 0)>
                  <#assign avgOtherDuration = totalOtherDuration / nOther>
                  <#assign avgOtherDurationInMinutes = avgOtherDuration?int>
                  <#assign avgOtherDurationInSeconds = ((avgOtherDuration - avgOtherDurationInMinutes) * 60)?int>
                  <td>${avgOtherDurationInMinutes}m${avgOtherDurationInSeconds}s</td>
                <#else>
                  <td>?</td>
                </#if>
                <td><a title="Console output" href="${jenkinsUri}/job/${jobName}/${buildNumber}/console">c</a></td>
                <td><a  title="FitNesse Report" href="${jenkinsUri}/job/${jobName}/${buildNumber}/Fitnesse_Report">fn</a></td>
                <#assign uri = testRun.getProperty('uri')>
                <#assign base = uri?substring(0, uri?index_of("/test/"))>
                <#assign runId = testRun.getTestRunId().toString()>
                <td><a  title="ReRun suite ${suiteName}" href="${base}/rerun/${runId}/${suiteName}">r</a></td>
                <td><a  title="Screenshots" href="${jenkinsUri}/job/${jobName}/${buildNumber}/artifact/FitNesseRoot/files/testResults/screenshots/${suiteName}">s</a></td>
              </tr>
            </#if>
          </#list>
        </#list>
</#macro>

<h1></h1>
<table>
  <caption>Execution duration per use case</caption>
  <tbody>
  <#assign runs = [testRun] >
  <#assign eventsFromThisRunMap = testRun.getEventsFromRunsAsMapGroupedBy('suiteName', runs, 'type:jobStatus', 'status:finished')>
  <#assign runs = testRun.getPreviousRuns(this.getProperty('maxRunsInHistory')) >
  <#assign eventsFromOtherRunsMap = testRun.getEventsFromRunsAsMapGroupedBy('suiteName', runs, 'type:jobStatus', 'status:finished')>

<@STATUS reason="timeout" title="Timed Out"/>
<@STATUS reason="aborted" title="Aborted by user"/>
<@STATUS reason="unstable" title="Execution considered Unstable"/>
<@STATUS reason="failure" title="Execution Failed"/>
<@STATUS reason="NULL" title="Execution ended in Unknown state"/>
<@STATUS reason="success" title="Execution Succeeded"/>
  </tbody>
</table>
