<#assign dashboardCombinationCreator = "com.xebialabs.xltest.bol.DashboardCombinationCreator"?new()>
<#macro RESULTTYPE result title>
<tr>
  <th colspan="9"><h3>${title}</h3></th>
</tr>
<tr>
    <th>Application</th><th>Use case Suite</th><th>Use case</th><th>Test Case</th><th>Priority</th><th>Team</th><th>Issue</th><th>Browser</th><th>Runtime</th><th>Info</th>
</tr>
<#list events as event>
  <#if event.type == 'functionalResult' && event.get('result') == result>
    <tr>
      <#assign application = event.get('application')>
      <#assign applicationPackage = event.get('applicationPackage')>
      <#assign usecase = event.get('usecase')>
      <#assign testcase = event.get('testcase')>
      <#assign buildNumber = event.get('buildNumber') >
      <#assign pageName = event.get('name') >
      <#if event.hasProperty('buildUrl')>
        <#assign jenkins_job_url = event.get('buildUrl') >
      </#if>
      <td><a href="http://localhost:8084/FrontPage.${application}">${application}</a></td>
      <td><a href="http://localhost:8084/FrontPage.${application}.${applicationPackage}">${applicationPackage}</a></td>
      <td><a href="http://localhost:8084/FrontPage.${application}.${applicationPackage}.${usecase}">${usecase}</a></td>
      <td><a href="http://localhost:8084/FrontPage.${application}.${applicationPackage}.${usecase}.${testcase}">${testcase}</a></td>
      <td>
        <#if event.hasProperty('priority')>
          ${event.get('priority')}
        </#if>
      </td>
      <td>
        <#if event.hasProperty('team')>
          ${event.get('team')}
        </#if>
      </td>
      <td>
        <#if event.hasProperty('issue')>
          <a href="${event.get('issue')}">${event.get('issue')}</a>
        </#if>
      </td>
      <td>
        <#if event.hasProperty('browser')>
          ${event.get('browser')}
        </#if>
      </td>
      <td style="white-space:nowrap;">
        <#if event.hasProperty('run_time')>
            <#if jenkins_job_url??>
              <a href="${jenkins_job_url}/Fitnesse_Report/${pageName}.html">${event.get('run_time')?number_to_datetime}</a>
            <#else>
          	  ${event.get('run_time')?number_to_datetime}
          	</#if>
        </#if>
      </td>
      <td>
        <#if jenkins_job_url??>
          <a href="${jenkins_job_url}/artifact/FitNesseRoot/files/testResults/screenshots/FrontPage.${application}.${applicationPackage}.${usecase}">sc</a>
        </#if>
      </td>
    </tr>
    <tr class="secondary">
      <td colspan="10">
        <#if event.hasProperty('testcasedescription')>
          <div>${event.get('testcasedescription')}</div>
        </#if>
        <#if event.hasProperty('firstError')>
          <div style="color:red">${event.get('firstError')}</div>
        </#if>
        <#if queryParameters?size &gt; 3>
          <#assign correspondingOlderEvents = testRun.getCorrespondingEventsFromOlderRuns(event, this.getProperty('maxRunsInHistory'), 'type', 'name')>
          <#assign thisResult = event.get('result')!"">
          <#assign prevResult = thisResult>
          <#assign nChanges = 0>
          <#assign total = 1>
          <#list correspondingOlderEvents as olderEvent>
            <#assign oldResult = olderEvent.get('result')!"">
            <#if oldResult != prevResult>
              <#assign prevResult = oldResult>
              <#assign nChanges = nChanges + 1>
            </#if>
            <#assign total = total + 1>
          </#list>

          <#assign flaky = ((nChanges / total) * 100)?floor >
          <br/>
          <table>
            <tr>
              <td><div title="Flakiness is the number of different test results over time divided by the number of test results">${flaky}% flaky</div></td>
              <#assign uri = testRun.getProperty('uri')>
              <#assign base = uri?substring(0, uri?index_of("/test/"))>
              <#assign olderEvent event>
              <#assign oldResult = olderEvent.get('result')!"">
              <#assign report_id = this.getId() >
              <#assign runId = olderEvent.get('runId') >
              <#assign applicationPackage = olderEvent.get('applicationPackage')!"" >
              <#assign team = olderEvent.get('team')!"" >
              <#assign application = olderEvent.get('application')!"" >
              <#assign usecase = olderEvent.get('usecase')!"" >
              <#assign runDay = this.thisDay(olderEvent.get('timestamp')) >
              <#if oldResult == "PASSED">
                <td bgcolor="green">
              <#else>
                <td bgcolor="red">
              </#if>
                <a href="${base}/#/reports/${runId}/${report_id}?applicationPackage=${applicationPackage}&team=${team}&application=${application}&usecase=${usecase}">${runDay}</a>
              </td>
              <#list correspondingOlderEvents as olderEvent>
                <#assign oldResult = olderEvent.get('result')!"">
                <#assign report_id = this.getId() >
                <#assign runId = olderEvent.get('runId') >
                <#assign applicationPackage = olderEvent.get('applicationPackage')!"" >
                <#assign team = olderEvent.get('team')!"" >
                <#assign application = olderEvent.get('application')!"" >
                <#assign usecase = olderEvent.get('usecase')!"" >
                <#assign runDay = this.thisDay(olderEvent.get('timestamp')) >
                <#if oldResult == "PASSED">
                  <td bgcolor="green">
                <#else>
                  <td bgcolor="red">
                </#if>
                  <a href="${base}/#/reports/${runId}/${report_id}?applicationPackage=${applicationPackage}&team=${team}&application=${application}&usecase=${usecase}">${runDay}</a>
                </td>
              </#list>
            </tr>
          </table>
        </#if>
      </td>
    </tr>
  </#if>
</#list>
</#macro>

<#macro TIMEOUTS>
  <#assign combination = dashboardCombinationCreator.getDashboardCombination(testRun, queryParameters)>
  <#assign timeoutEvents = dashboardCombinationCreator.getNonAppliedTimeoutsNotHavingNewerResultsFromDashboardCombination(combination)>
  <tr>
    <th colspan="10"><h3>Timeouts</h3></th>
  </tr>
  <tr>
    <th>Application</th><th>Use case Suite</th><th>Use case</th><th>Test Case</th><th>Priority</th><th>Team</th><th>Issue</th><th>Browser</th><th>Runtime</th><th>Info</th>
  </tr>
  <#list timeoutEvents as event>
      <tr>
        <#assign application = event.get('application')>
        <#assign applicationPackage = event.get('applicationPackage')>
        <#assign usecase = event.get('usecase')>
        <#assign ntests = event.get('ntests')>
        <#if event.hasProperty('buildNumber')>
          <#assign buildNumber = event.get('buildNumber')>
        <#else>
          <#assign buildNumber = "NoBuildNumberFoundInJobStatusEvent" >
        </#if>
        <#if event.hasProperty('buildUrl')>
          <#assign jenkins_job_url = event.get('buildUrl') >
        </#if>
        <#assign pageName = event.get('suiteName') >
        <td><a href="http://localhost:8084/FrontPage.${application}">${application}</a></td>
        <td><a href="http://localhost:8084/FrontPage.${application}.${applicationPackage}">${applicationPackage}</a></td>
        <td><a href="http://localhost:8084/FrontPage.${application}.${applicationPackage}.${usecase}">${usecase}</a></td>
        <td> ${ntests} tests</td>
        <td></td>
        <td>
          <#if event.hasProperty('team')>
            ${event.get('team')}
          </#if>
        </td>
        <td></td>
        <td>
          <#if event.hasProperty('browser')>
            ${event.get('browser')}
          </#if>
        </td>
        <td>
          <#if event.hasProperty('run_time')>
            <#if jenkins_job_url??>
              <a href="${jenkins_job_url}/Fitnesse_Report/${pageName}.html">${event.get('run_time')?number_to_datetime}</a>
            <#else>
              ${event.get('run_time')?number_to_datetime}
            </#if>
          </#if>
        </td>
        <td></td>
      </tr>
  </#list>
</#macro>
<#assign events = testRun.getEvents(queryParameters, 'name') >
<#assign jenkinsUri = testRun.getProperty('jenkinsUri') >
<#assign jobName = testRun.getProperty('jobName') >
<#assign jenkins_job_url = jenkinsUri + "/job/" + jobName + "/">

<table class="table two-rows">
<tbody>
<@RESULTTYPE result="FAILED" title="Failed"/>
<@RESULTTYPE result="NOT RUN" title="Not Run"/>
<@TIMEOUTS />
<#if queryParameters?size &gt; 0>
<@RESULTTYPE result="KNOWN ISSUE" title="Known Failed"/>
<@RESULTTYPE result="PASSED" title="Passed"/>
</#if>
</tbody>
</table>

