# self is an instance of Report, 'repository' is the JCR repo and 'testRun' contains info about the run.
# pass the result into 'resultholder' like this: resultHolder.setResult({ 'success': success })

from java.util import Date
import operator
from java.lang import IllegalArgumentException
from urllib2 import quote
from com.xebialabs.xltest.bol import DashboardCombinationCreator

def nextDrilldownLevel(drilldownsequence, queryParameters):
    keys = queryParameters.keySet()
    for drilldown in drilldownsequence:
        if not keys.contains(drilldown):
            return drilldown, True
    return drilldownsequence[-1], False

def makeDrilldownUrl(xaxis):
    drilldown = self.getProperty('drilldown')
    queryStr = '&'.join(quote(k) + '=' + quote(v) for k, v in dict(queryParameters).iteritems())
    queryStr = queryStr and (queryStr + '&') or ''
    if drilldown:
        return '%s/%s?%s%s=' % (id, drilldown.id, queryStr, xaxis)
    else:
        return ''


def get_environment(testRun):
    'Not all events have an environment property. Implement a default'
    try:
        return testRun.getProperty('environment')
    except IllegalArgumentException:
        return "DEVELOP"

def make_column_values(group_map, categories):
    return map(lambda t: group_map.has_key(t) and { 'y': sum(group_map[t]), 'url': URL and (URL + t) } or None, categories)


id = testRun.getTestRunId()
environment = get_environment(testRun)
startTime = testRun.startTime
drilldownsequence = self.getProperty('drilldownsequence')
xaxis, canDrillDown = nextDrilldownLevel(drilldownsequence, queryParameters)
URL = makeDrilldownUrl(xaxis)


combination = DashboardCombinationCreator().getDashboardCombination(testRun, queryParameters)
event_map = dict(combination.getEventMap())
timeouts = combination.getTimeouts()
failures = combination.getFailures()
applied_timeouts = combination.getAppliedTimeouts()
oldTimeoutsThatNowHaveAResult = combination.getOldTimeoutsThatNowHaveAResult()

# Okay, at this point event_map is a map[page name -> event].

if event_map:
    passed = {}
    failed = {}
    known = {}
    notfound = {}
    timeout = {}
    for ev in event_map.itervalues():
        x = ev.get(xaxis)
        if x and ev.type == 'functionalResult':
            result = ev.get('result')
            if x is None:
                continue
            if result == 'PASSED':
                passed.setdefault(x, []).append(1)
            elif result == 'KNOWN ISSUE':
                known.setdefault(x, []).append(1)
            elif result == 'NOT_FOUND':
                notfound.setdefault(x, []).append(1)
            else:
                failed.setdefault(x, []).append(1)
        elif x and ev.type == 'jobStatus' and ev.getProperties().get('reason') == 'timeout':
            # Add one for each event that has been overridden by a timeout
            timeout.setdefault(x, []).append(1)
        elif x and ev.type == 'jobStatus' and ev.getProperties().get('reason') == 'failure':
            notfound.setdefault(x, []).append(1)

    # Also report on timeouts for which no events have been reported at all. Those need to be processed separately.
    for to in timeouts:
        if to in applied_timeouts or to in oldTimeoutsThatNowHaveAResult:
            continue
        x = to.get(xaxis)
        if x:
            ntests = to.get('ntests')
            if ntests is None:
                ntests = 0
            timeout.setdefault(x, []).append(ntests)

    for f in failures:
        if f in applied_timeouts or f in oldTimeoutsThatNowHaveAResult:
            continue
        x = f.get(xaxis)
        if x:
            ntests = f.get('ntests')
            if ntests is None:
                ntests = 0
            notfound.setdefault(x, []).append(ntests)


    categories = sorted(set(failed.keys() + passed.keys() + known.keys() + notfound.keys() +timeout.keys()))

    passed = make_column_values(passed, categories)
    failed = make_column_values(failed, categories)
    known = make_column_values(known, categories)
    notfound = make_column_values(notfound, categories)
    timeout = make_column_values(timeout, categories)

    categories = map(lambda x: x[:20], categories)

    if xaxis == 'team':
        rotation = 0
    else:
        rotation = -45


    resultHolder.setResult(
        {
            'chart': {
                'type': 'column',
                'animation': False
            },
            'title': {
                'text': 'Test result overview per %s' % xaxis
            },
            'xAxis': {
                'categories': categories,
                'labels': {
                    'rotation': rotation
                }
            },
            'yAxis': {
                'min': 0,
                'title': {
                    'text': 'Total tests'
                },
                'stackLabels': {
                    'enabled': True,
                },
                'minTickInterval': 1
            },
            'colors': ['#ABD718', '#D31155', '#055F75', '#E36C16', '#009190'],
            'plotOptions': {
                'column': {
                    'animation': False,
                    'cursor': 'pointer',
                    'stacking': 'normal',
                    'dataLabels': {
                        'enabled': True,
                        'color': 'white'
                    }
                },
                'series': canDrillDown and {
                    'point': {
                        'events': {
                            'click': 'url'
                        }
                    }
                } or None
            },
            'credits': {
                'enabled': False
            },
            "series": [{
                           "name": "Passed",
                           "data": passed
                       },
                       {
                           "name": "Failed",
                           "data": failed
                       },
                       {
                           "name": "No Results Found",
                           "data": notfound
                       },
                       {
                           "name": "Known Issue",
                           "data": known
                       },
                       {
                           "name": "Timeout",
                           "data": timeout
                       }]
        })

