package com.xebialabs.xltest.bol.freemarker;

import com.xebialabs.xltest.bol.DashboardCombinationCreator;
import com.xebialabs.xltest.domain.TestRun;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.*;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@SuppressWarnings("serial")
public class DashboardReport extends com.xebialabs.xltest.domain.Report {

    private static Logger LOG = LoggerFactory.getLogger(DashboardReport.class);


    @Override
    public String compute(TestRun testRun) {
    	String format;
		try {
			format = readTemplateFile(getScriptLocation());
		} catch (IOException e) {
			e.printStackTrace();
			throw new RuntimeException("Could not perform freemarker report transformation.", e);
		}
    	Map<String, Object> templateProperties = new HashMap(getAttributes());
    	templateProperties.put("testRun", testRun);
    	templateProperties.put("this", this);
        templateProperties.put("dashboardCombinationCreator", new DashboardCombinationCreator(getTestRunsRepository()));
        for (String key : templateProperties.keySet()) {
        	LOG.debug("freemarker report has context property: " + key + " with value: " + templateProperties.get(key) + " (instance of " + (templateProperties.get(key)).getClass().getName() + ")");
        }
    	return format(templateProperties, format);
    }
    
    
    private String readTemplateFile(String fileName) throws IOException {
		InputStream is = this.getClass().getResourceAsStream("/" + fileName);
		BufferedReader br = new BufferedReader(new InputStreamReader(is));
		StringBuilder sb = new StringBuilder();
		String line;
		while ((line = br.readLine()) != null) {
			sb.append(line);
			sb.append("\n");
		}
		return sb.toString();
	}

	private String format(Map<String, Object> properties, String format) {
		try {
			Configuration cfg = new Configuration();
			cfg.clearTemplateCache();
			Template t = new Template(getScriptLocation(), new StringReader(format), cfg);
			StringWriter sw = new StringWriter();
			t.process(properties, sw);
			return sw.toString();
		} catch (IOException e) {
			e.printStackTrace();
			return e.getMessage();
		} catch (TemplateException e) {
			e.printStackTrace();
			return e.getMessage();
		}
	}
	
	// TODO think about where these kind of small reporting utils really belong 
	public String nextDate(Date date) {
		Date nextDate = new Date(date.getTime() + 24 * 60 * 60 * 1000);
		SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
		return format.format(nextDate);
	}
	public String previousDate (Date date) {
		Date previousDate = new Date(date.getTime() - 24 * 60 * 60 * 1000);
		SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
		return format.format(previousDate);
	}
	public String thisDay (Long date) {
		SimpleDateFormat format = new SimpleDateFormat("dd");
		return format.format(new Date(date));
	}
	
	public String getAttributeAsString(String key) {
		if (getAttributes() != null) {	
			return getAttributes().get(key).toString();
		}
		return "";
    }
}
