package com.xebialabs.xltest.bol;

import java.io.IOException;
import java.net.URI;
import java.util.UUID;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.xltest.domain.TestRun;
import com.xebialabs.xltest.domain.TestSpecification;
import com.xebialabs.xltest.repository.TestRunsRepository;

@Controller
@Path("/rerun")
@Produces(MediaType.APPLICATION_JSON)
@Consumes(MediaType.APPLICATION_JSON)
public class RerunTestController {
	private static final Logger LOG = LoggerFactory.getLogger(RerunTestController.class);
	
    private final RepositoryService repository;
    private final TestRunsRepository testRunsRepository;

    @Autowired
    public RerunTestController(RepositoryService repository, TestRunsRepository testRunsRepository) {
        this.repository = repository;
        this.testRunsRepository = testRunsRepository;
    }

	@GET
	@Path("{testRunId:[\\w-]+}/{suite:.+}")
	public Response rerunSlice(@PathParam("testRunId") String testRunId, @PathParam("suite") String suite, @HeaderParam("xltest-base") String xlTestBase, @Context final UriInfo uriInfo)
			throws IOException, InterruptedException {
		LOG.info("Attempting to re-run suite {} that was part of test run {}", suite, testRunId);
        // TODO: Fix code.
		TestSpecification testRun = new TestSpecification(); //findOldRun(testRunId);

//		TestSetDefinition systemSlicedRerunDefinition = findAndCreateIfNecessary(testRun, suite);
//		systemSlicedRerunDefinition.setProperty("parent", testRun.getTestSetDefinition());

		String taskId = fireTest(testRun, xlTestBase, uriInfo);
		URI location = URI.create("#/testruns/" + taskId);
		return Response.temporaryRedirect(location).build();
	}
    
	public String fireTest(final TestSpecification testRun, String xlTestBase, UriInfo uriInfo) {
        URI xlTestBaseUri = (xlTestBase != null) ? URI.create(xlTestBase + "/test") : uriInfo.getAbsolutePath();
        return ""; //testRunner.run(testRun, xlTestBaseUri);
	}


	private TestRun findOldRun(String testRunId) {
		return testRunsRepository.getTestRun(UUID.fromString(testRunId));
	}

	private TestSpecification findAndCreateIfNecessary(TestRun oldRun, String suite) {
		TestSpecification systemSliceRerun;
		String id = "Configuration/TestSetDefinitions/systemSliceRerun";
		try {
			systemSliceRerun = repository.read(id);
		} catch (NotFoundException nfe) {
			Type bolSlice = Type.valueOf("bol.SlicedFitNesseSubSet");
			systemSliceRerun = bolSlice.getDescriptor().newInstance(id);
			systemSliceRerun.setProperty("parent", oldRun.getTestSpecificationName());
			repository.create(systemSliceRerun);
		}
		systemSliceRerun.setProperty("suiteName", suite);
		return systemSliceRerun;
	}
}
