<#macro TIMEOUTLINE event>
      <tr>
        <#assign application = event.get('application')>
        <#assign applicationPackage = event.get('applicationPackage')>
        <#assign usecase = event.get('usecase')>
        <#assign ntests = event.get('ntests')>
        <#if event.hasProperty('buildNumber')>
          <#assign buildNumber = event.get('buildNumber')>
        <#else>
          <#assign buildNumber = "NoBuildNumberFoundInJobStatusEvent" >
        </#if>
        <#if event.hasProperty('buildUrl')>
          <#assign jenkins_job_url = event.get('buildUrl') >
        </#if>
        <#assign pageName = event.get('suiteName') >
        <td><a href="http://localhost:8084/FrontPage.${application}.${applicationPackage}">${applicationPackage}</a></td>
        <td><a href="http://localhost:8084/FrontPage.${application}.${applicationPackage}.${usecase}">${usecase}</a></td>
        <td> ${ntests} tests</td>
        <td></td>
        <td>
          <#if event.hasProperty('team')>
            ${event.get('team')}
          </#if>
        </td>
        <td></td>
        <td>
          <#if event.hasProperty('browser')>
            ${event.get('browser')}
          </#if>
        </td>
        <td>
          <#if event.hasProperty('run_time')>
            <#if jenkins_job_url??>
              <a href="${jenkins_job_url}/Fitnesse_Report/${pageName}.html">${event.get('run_time')?number_to_datetime}</a>
            <#else>
          	  ${event.get('run_time')?number_to_datetime}
          	</#if>
          </#if>
        </td>
        <td></td>
      </tr>
</#macro>

<#macro RESULTTYPE result title>
<tr>
  <th colspan="9"><h3>${title}</h3></th>
</tr>
<tr>
  <th>Use case Suite</th><th>Use case</th><th>Test Case</th><th>Priority</th><th>Team</th><th>Issue</th><th>Browser</th><th>Runtime</th><th>Info</th>
</tr>
<#assign events = testRun.getResultEventsFromDashboardCombination(combination, result)>
<#list events as event>
  <#if event.type == 'result'>
    <tr>
      <#assign application = event.get('application')>
      <#assign applicationPackage = event.get('applicationPackage')>
      <#assign usecase = event.get('usecase')>
      <#assign testcase = event.get('testcase')>
      <#assign buildNumber = event.get('buildNumber') >
      <#if event.hasProperty('buildUrl')>
        <#assign jenkins_job_url = event.get('buildUrl') >
      </#if>
      <#assign pageName = event.get('pageName') >
      <td><a href="http://localhost:8084/FrontPage.${application}.${applicationPackage}">${applicationPackage}</a></td>
      <td><a href="http://localhost:8084/FrontPage.${application}.${applicationPackage}.${usecase}">${usecase}</a></td>
      <td><a href="http://localhost:8084/FrontPage.${application}.${applicationPackage}.${usecase}.${testcase}">${testcase}</a></td>
      <td>
        <#if event.hasProperty('priority')>
          ${event.get('priority')}
        </#if>
      </td>
      <td>
        <#if event.hasProperty('team')>
          ${event.get('team')}
        </#if>
      </td>
      <td>
        <#if event.hasProperty('issue')>
          <a href="${event.get('issue')}">${event.get('issue')}</a>
        </#if>
      </td>
      <td>
        <#if event.hasProperty('browser')>
          ${event.get('browser')}
        </#if>
      </td>
      <td style="white-space:nowrap;">
        <#if event.hasProperty('run_time')>
            <#if jenkins_job_url??>
              <a href="${jenkins_job_url}/Fitnesse_Report/${pageName}.html">${event.get('run_time')?number_to_datetime}</a>
            <#else>
          	  ${event.get('run_time')?number_to_datetime}
          	</#if>
        </#if>
      </td>
      <td>
        <#if event.hasProperty('info')>
            <#if jenkins_job_url??>
              <a href="${jenkins_job_url}/artifact/FitNesseRoot/files/testResults/screenshots/FrontPage.${application}.${applicationPackage}.${usecase}">${event.get('info')}</a>
            <#else>
          	  ${event.get('info')}
          	</#if>
        </#if>
      </td>
    </tr>
    <tr class="secondary">
      <td colspan="9">
        <#if event.hasProperty('testcasedescription')>
          <div>${event.get('testcasedescription')}</div>
        </#if>
        <#if event.hasProperty('firstError')>
          <div style="color:red">${event.get('firstError')}</div>
        </#if>
      </td>
    </tr>
  </#if>
</#list>
<#if result == "NOT RUN">
  <#assign events = testRun.getJobStatusEventsFromDashboardCombination(combination, "jobStatus")>
  <#list events as event>
    <#if event.type == 'jobStatus'>
      <@TIMEOUTLINE event = event/>
    </#if>
  </#list>
  <#assign events = testRun.getNonAppliedTimeoutsNotHavingNewerResultsFromDashboardCombination(combination)>
  <#list events as event>
    <#if event.type == 'jobStatus'>
      <@TIMEOUTLINE event = event/>
    </#if>
  </#list>
</#if>
</#macro>



<#if (queryParameters?size == 0)>
  <#assign reportId = this.getId() >
  <#assign parameters = "">
  <#if testRun.hasProperty('browser') >
    <#assign parameters = parameters + "Browser: " + testRun.getProperty('browser') + " ">
  </#if>
  <#if testRun.hasProperty('suiteFilter') >
    <#assign parameters = parameters + "SuiteFilter: " + testRun.getProperty('suiteFilter') + " ">
  </#if>
  <#assign nextDate = this.nextDate(testRun.getProperty('startTime'))>
  <#assign previousDate = this.previousDate(testRun.getProperty('startTime'))>
  <#assign environment = testRun.getProperty('environment')>
  <#assign uri = testRun.getProperty('uri')>
  <#assign rightLink = "?report=monitor&amp;date=" + nextDate +"&amp;environment=" + environment>
  <#assign leftLink = "?report=monitor&amp;date=" + previousDate +"&amp;environment=" + environment>
  <table width="100%">
    <tr width="100%">
      <td><a href="${leftLink}">&lt;&lt;</a></td>
      <td>Other parameters: ${parameters}</td>
      <td><a href="${rightLink}">&gt;&gt;</a></td>
    </tr>
  </table>
<#else>
  <#assign combination = testRun.getDashboardCombination(queryParameters)>
  <table class="table two-rows">
    <tbody  bgcolor="white" fgcolor="black">
      <@RESULTTYPE result="FAILED" title="Failed"/>
      <@RESULTTYPE result="NOT RUN" title="Not Run"/>
      <@RESULTTYPE result="KNOWN ISSUE" title="Known Failed"/>
      <@RESULTTYPE result="PASSED" title="Passed"/>
    </tbody>
  </table>
</#if>
