# self is an instance of Report, 'repository' is the JCR repo and 'testRun' contains info about the run.
# pass the result into 'resultholder' like this: resultHolder.setResult({ 'success': success })

from java.util import Date
import operator
from java.lang import IllegalArgumentException
from urllib2 import quote


def nextDrilldownLevel(drilldownsequence, queryParameters):
    keys = queryParameters.keySet()
    for drilldown in drilldownsequence:
        if not keys.contains(drilldown):
            return drilldown, True
    return drilldownsequence[-1], False

def makeDrilldownUrl(xaxis):
    drilldown = self.getProperty('drilldown')
    queryStr = '&'.join(quote(k) + '=' + quote(v) for k, v in dict(queryParameters).iteritems())
    queryStr = queryStr and (queryStr + '&') or ''
    if drilldown:
        return '%s/%s?%s%s=' % (id, drilldown.id, queryStr, xaxis)
    else:
        return ''

def aggregate_results(events, timeouts, keyAttr='pageName'):
    agg = {}
    applied_timeouts = set()
    oldTimeoutsThatNowHaveAResult = set()
    for e in events:
        key = e.get(keyAttr)
        other = agg.get(key)
        if not other or other.get('_ts') < e.get('_ts'):
            agg[key] = e
        for to in timeouts:
            if key.startswith(to.get('suiteName') + '.') and to.get('_ts') > e.get('_ts'):
                agg[key] = to
                applied_timeouts.add(to)
                break
            if key.startswith(to.get('suiteName') + '.') and to.get('_ts') < e.get('_ts'):
                oldTimeoutsThatNowHaveAResult.add(to)
                break
    return agg, applied_timeouts, oldTimeoutsThatNowHaveAResult

def get_environment(testRun):
    'Not all events have an environment property. Implement a default'
    try:
        return testRun.getProperty('environment')
    except IllegalArgumentException:
        return "DEVELOP"

def make_column_values(group_map, categories):
    return map(lambda t: group_map.has_key(t) and { 'y': sum(group_map[t]), 'url': URL and (URL + t) } or None, categories)


id = testRun.getTestRunId()
environment = get_environment(testRun)
startTime = testRun.startTime
drilldownsequence = self.getProperty('drilldownsequence')
xaxis, canDrillDown = nextDrilldownLevel(drilldownsequence, queryParameters)
URL = makeDrilldownUrl(xaxis)

now = testRun.finishedTime or Date()
hours = now.hours
minutes = now.minutes
seconds = now.seconds
totalseconds = (hours * 60 * 60) + (minutes * 60) + seconds 
start_of_day = Date(now.time - totalseconds * 1000)
if testRun.finishedTime is not None and testRun.startTime.day != testRun.finishedTime.day:
    # we finishes in the next day, so start_of_day which is derived from finishedtime is 24 hours later
    # and the end of the day is already held by the now computed start_of_day
    now = start_of_day
    start_of_day = Date(start_of_day.time - (24 * 60 * 60) * 1000)
eventProperties = {'type': 'jobStatus', 'status': 'finished'}
if environment != 'DEVELOP':
    eventProperties['environment'] = environment
finished_events = testRun.getEventsBetween(start_of_day.time, now.time, eventProperties)

test_run_ids = set(map(operator.attrgetter('testRunId'), finished_events))

results = []
eventProperties = {'type': 'result', 'run_id': id.toString()}
eventProperties.update(queryParameters)
twentyFourHoursInMillis = 24 * 60 * 60 * 1000;
end_of_day = Date(start_of_day.time + twentyFourHoursInMillis)
for id in test_run_ids:
    eventProperties['run_id'] = id.toString()
    results.extend(testRun.getEventsBetweenInRunId(start_of_day.time, end_of_day.time, eventProperties, id.toString()))


def matchingQueryParameters(e):
    for k, v in dict(queryParameters).iteritems():
        if not e.hasProperty(k) or e.get(k) != v:
            return False
    return True

def most_recent_slice(timeouts):
    slice_timeout_dict = {}
    for to in timeouts:
        if to.get('suiteName') in slice_timeout_dict.keys():
            # replace if newer
            other_to = slice_timeout_dict[to.get('suiteName')]
            if to.get('_ts') > other_to.get('_ts'):
                slice_timeout_dict[to.get('suiteName')] = to
        else:
            slice_timeout_dict[to.get('suiteName')] = to
    return slice_timeout_dict.values()

timeouts = [ e for e in finished_events if e.properties.get('reason') == 'timeout' and matchingQueryParameters(e)]
timeouts = most_recent_slice(timeouts)

event_map, applied_timeouts, oldTimeoutsThatNowHaveAResult = aggregate_results(results, timeouts)

# Okay, at this point event_map is a map[page name -> event].

if event_map:
    passed = {}
    failed = {}
    known = {}
    notrun = {}
    timeout = {}
    for ev in event_map.itervalues():
        x = ev.get(xaxis)
        if x and ev.type == 'result':
            result = ev.get('result')
            if x is None:
                continue
            if result == 'PASSED':
                passed.setdefault(x, []).append(1)
            elif result == 'KNOWN ISSUE':
                known.setdefault(x, []).append(1)
            elif result == 'NOT RUN':
                notrun.setdefault(x, []).append(1)
            else:
                failed.setdefault(x, []).append(1)
        if x and ev.type == 'jobStatus': # The timeout events:
            timeout.setdefault(x, []).append(1)

    for to in timeouts:
        if to in applied_timeouts:
            continue
        if to in oldTimeoutsThatNowHaveAResult:
            continue
        x = to.get(xaxis)
        if x:
            ntests = to.get('ntests')
            if ntests is None:
                ntests = 0
            timeout.setdefault(x, []).append(ntests)

    categories = sorted(set(failed.keys() + passed.keys() + known.keys() + notrun.keys() + timeout.keys()))

    passed = make_column_values(passed, categories)
    failed = make_column_values(failed, categories)
    known = make_column_values(known, categories)
    notrun = make_column_values(notrun, categories)
    timeout = make_column_values(timeout, categories)

    categories = map(lambda x: x[:20], categories)

    if xaxis == 'team':
        rotation = 0
    else:
        rotation = -45


    resultHolder.setResult(
        {
            'chart': {
                'type': 'column',
                'animation': False
            },
            'title': {
                'text': 'Test result overview per %s' % xaxis
            },
            'xAxis': {
                'categories': categories,
                'labels': {
                    'rotation': rotation
                }
            },
            'yAxis': {
                'min': 0,
                'title': {
                    'text': 'Total tests'
                },
                'stackLabels': {
                    'enabled': True,
                },
                'minTickInterval': 1
            },
            'colors': ['#ABD718', '#D31155', '#055F75', '#E36C16', '#009190'],
            'plotOptions': {
                'column': {
                    'animation': False,
                    'cursor': 'pointer',
                    'stacking': 'normal',
                    'dataLabels': {
                        'enabled': True,
                        'color': 'white'
                    }
                },
                'series': canDrillDown and {
                    'point': {
                        'events': {
                            'click': 'url'
                        }
                    }
                } or None
            },
            'credits': {
                'enabled': False
            },
            "series": [{
                           "name": "Passed",
                           "data": passed
                       },
                       {
                           "name": "Failed",
                           "data": failed
                       },
                       {
                           "name": "Not run",
                           "data": notrun
                       },
                       {
                           "name": "Known Issue",
                           "data": known
                       },
                       {
                           "name": "Timeout",
                           "data": timeout
                       }]
        })

