from java.util import Date
from java.text import SimpleDateFormat

id = testRun.getTestRunId()


now = testRun.startTime or Date()
hours = now.hours
minutes = now.minutes
seconds = now.seconds
totalseconds = (hours * 60 * 60) + (minutes * 60) + seconds 
start_of_day = Date(now.time - totalseconds * 1000)

title = self.getProperty('title')
if testRun.hasProperty('environment') and testRun.getProperty('environment') != "":
    format = SimpleDateFormat("yyyy-MM-dd")
    dateString = format.format(start_of_day)
    title = title + ' for ' + dateString + ' on ' + testRun.getProperty('environment')
    
topLeftReport = self.getProperty('topLeft')
topRightReport = self.getProperty('topRight')
bottomReport = self.getProperty('bottom')

params = '&'.join(k + '=' + v for k, v in dict(queryParameters).iteritems())
subtitle = ', '.join(k + ': ' + v for k, v in dict(queryParameters).iteritems())

if subtitle and subtitle != "":
    report = { 'title': title + '; ' + subtitle }
else:
    report = { 'title': title}
    
if topLeftReport:
    report['topLeft'] = '%s/%s?%s' % (id, topLeftReport.id, params)

if topRightReport:
   report['topRight'] = '%s/%s?%s' % (id, topRightReport.id, params)

if bottomReport:
   report['bottom'] = '%s/%s?%s' % (id, bottomReport.id, params)

resultHolder.setResult(report)
