/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.bol;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.xltest.domain.TestRun;
import com.xebialabs.xltest.domain.TestSetDefinition;
import com.xebialabs.xltest.service.TestRunner;
import java.io.IOException;
import java.net.URI;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
@Path(value="/rerun")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class RerunTestController {
    private static final Logger LOG = LoggerFactory.getLogger(RerunTestController.class);
    private final RepositoryService repository;
    private final TestRunner testRunner;

    @Autowired
    public RerunTestController(RepositoryService repository, TestRunner testRunner) {
        this.repository = repository;
        this.testRunner = testRunner;
    }

    @GET
    @Path(value="{testRunId:[\\w-]+}/{suite:.+}")
    public Response rerunSlice(@PathParam(value="testRunId") String testRunId, @PathParam(value="suite") String suite, @HeaderParam(value="xltest-base") String xlTestBase, @Context UriInfo uriInfo) throws IOException, InterruptedException {
        LOG.info("Attempting to re-run suite {} that was part of test run {}", (Object)suite, (Object)testRunId);
        TestRun oldRun = this.findOldRun(testRunId);
        TestSetDefinition systemSlicedRerunDefinition = this.findAndCreateIfNecessary(oldRun, suite);
        Type runType = oldRun.getType();
        TestRun testRun = (TestRun)runType.getDescriptor().newInstance("");
        testRun.setTestSetDefinition(systemSlicedRerunDefinition);
        testRun.setProperty("jenkinsUri", oldRun.getProperty("jenkinsUri"));
        testRun.setProperty("jobName", oldRun.getProperty("jobName"));
        testRun.setProperty("maxQueueSize", oldRun.getProperty("maxQueueSize"));
        testRun.setProperty("environment", oldRun.getProperty("environment"));
        testRun.setProperty("browser", oldRun.getProperty("browser"));
        testRun.setProperty("suiteFilter", oldRun.getProperty("suiteFilter"));
        TestRun newRun = this.fireTest(testRun, xlTestBase, uriInfo);
        String newRunId = newRun.getName();
        URI location = URI.create("#/testruns/" + newRunId);
        return Response.temporaryRedirect((URI)location).build();
    }

    public TestRun fireTest(TestRun testRun, String xlTestBase, UriInfo uriInfo) throws IOException, InterruptedException {
        URI xlTestBaseUri = xlTestBase != null ? URI.create(xlTestBase + "/test") : uriInfo.getAbsolutePath();
        return this.testRunner.run(testRun, xlTestBaseUri);
    }

    private TestRun findOldRun(String testRunId) {
        return (TestRun)this.repository.read("Applications/TestRuns/" + testRunId);
    }

    private TestSetDefinition findAndCreateIfNecessary(TestRun oldRun, String suite) {
        TestSetDefinition systemSliceRerun = null;
        String id = "Configuration/TestSetDefinitions/systemSliceRerun";
        try {
            systemSliceRerun = (TestSetDefinition)this.repository.read(id);
        }
        catch (NotFoundException nfe) {
            Type bolSlice = Type.valueOf((String)"bol.SlicedFitNesseSubSet");
            systemSliceRerun = (TestSetDefinition)bolSlice.getDescriptor().newInstance(id);
            systemSliceRerun.setProperty("parent", (Object)oldRun.getTestSetDefinition());
            this.repository.create((ConfigurationItem[])new TestSetDefinition[]{systemSliceRerun});
        }
        systemSliceRerun.setProperty("suiteName", (Object)suite);
        return systemSliceRerun;
    }
}

