from com.xebialabs.xltest.plan import ParallelPlan, SerialPlan, TestPlan
from com.xebialabs.overthere import CmdLine
from com.xebialabs.deployit.plugin.api.reflect import DescriptorRegistry, Type
from org.slf4j import LoggerFactory
from subprocess import call
import shutil
import os, re

LOG = LoggerFactory.getLogger("Slice FitNesse")
WIKI_WORD = re.compile(r'^[A-Z][a-z0-9]+(?:[A-Z][a-z0-9]*)+$')

FitNesseSlice = DescriptorRegistry.getDescriptor(Type.valueOf("bol.FitNesseSlice")).newInstance


timeout = self.getProperty('timeoutPerSlice')
longtimeout = self.getProperty('longtimeoutPerSlice')
scmUrl = self.getProperty('repositoryUrl')
branchOrRevision = self.getProperty('branch')
workDir = self.getProperty('workingDir')
suiteName = self.getProperty('suiteName')
blacklistfile = self.getProperty('blacklistfile')
longtimeoutfile = self.getProperty('longtimeoutfile')

LOG.info("Updating working tree")

print "I am NOT cleaning dir:", workDir, "then checkout revision:", branchOrRevision, "using scm URL:", scmUrl
# shutil.rmtree(workDir, True)
#print "Cleaned dir:", workDir
exitcode = call(["mkdir", "-p", workDir])
if not exitcode == 0:
    raise RuntimeError("Could not create dir " + workDir + " exitcode was: " + str(exitcode))
print "Created fresh dir:", workDir, "exitcode", exitcode, "Now checking out"
exitcode = call(["svn", "co", scmUrl + os.sep + branchOrRevision, workDir])
if not exitcode == 0:
    print "Could checkout " + scmUrl+ os.sep + branchOrRevision  + " exitcode was: " + str(exitcode)
    raise RuntimeError("Could checkout " + scmUrl+ os.sep + branchOrRevision  + " exitcode was: " + str(exitcode))
suitePath = os.path.join(*([workDir, 'FitNesseRoot'] + suiteName.split('.')))



LOG.info("Updating working tree {}... done", suitePath)

LOG.info("Scanning working tree for test suites")

def blacklisted(pages):
    full_page_name = '.'.join(pages)
    return full_page_name in blacklisted_pages

def find_test_suites(workDir, pages=()):
    for page_name in os.listdir(workDir):
        if not WIKI_WORD.match(page_name):
            continue

        path = os.path.join(workDir, page_name)
        if not os.path.isdir(path):
            continue

        if len(pages) == 3:
            if blacklisted(pages):
                full_page_name = '.'.join(pages)
                LOG.info('NOT adding {} to plan as it is blacklisted', full_page_name)
                continue
            yield '.'.join(pages)
        else:
            for p in find_test_suites(path, pages + (page_name,)):
                yield p


def make_plan(sliceName):
    full_path = '.'.join([suiteName, sliceName])
    tsd = FitNesseSlice(full_path)
    tsd.setProperty('suiteName', full_path)
    if sliceName in longtimeout_pages:
        LOG.info('Adding {} to plan. slice {} has a longtimeout', full_path, sliceName)
        tsd.setProperty('timeout', longtimeout)
    else:
        tsd.setProperty('timeout', timeout)
        LOG.info('Adding {} to plan. slice {} has a normal timeout', full_path, sliceName)
    tsd.setProperty('repositoryUrl', scmUrl)
    tsd.setProperty('branch', branchOrRevision)
    if sliceName.startswith('CrmSuite.'):
        tsd.setProperty('slave', 'TA-CRM')
        tsd.setProperty('suiteFilter', 'NightlyIE')
        tsd.setProperty('browser', 'iexplore')
        tsd.setProperty('webdriver', 'BrowserExtensions/IEDriverServer.exe')
    else:
        tsd.setProperty('slave', 'fitnesse')
        tsd.setProperty('browser', 'firefox')
        tsd.setProperty('webdriver', '')
    return TestPlan(tsd, CmdLine().addArgument("./startSubTestRun.sh").addArgument(full_path))

def readFileWithPages(filename):
    if os.path.exists(filename):
        f = open(filename)
        pages = f.readlines()
        f.close()
        return [l.strip('\n\r') for l in pages]
    return ()


blacklisted_pages = readFileWithPages(blacklistfile)
print 'blacklisted pages', blacklisted_pages

longtimeout_pages = readFileWithPages(longtimeoutfile)
print 'longtimeout pages', longtimeout_pages


# Make it a set, so duplicates from find_test_suites() are eliminated
resultHolder.setResult(ParallelPlan([make_plan(s) for s in set(find_test_suites(str(suitePath)))]))
