<#macro STATUS title>
    <#assign shouldPrintHeader = true >

        <#assign eventsMap = testRun.getEventsFromRunsAsMapGroupedBy('slave', runs, 'type:jobStatus', 'status:finished')>
        <#list eventsMap?keys as slave>
        <#if slave??>
          <#if shouldPrintHeader >
            <tr>
              <th colspan="7"><h3>${title}</h3></th>
            </tr>
            <tr>
              <th>Slave</th><th>Total</th><th>Success</th><th>Unstable</th><th>Failed</th><th>?</th><th>Timeout</th>
            </tr>
            <#assign shouldPrintHeader = false >
          </#if>
          <#assign events = eventsMap[slave] >
          <#assign first = true >
          <#assign timeout = 0>
          <#assign aborted = 0>
          <#assign unstable = 0>
          <#assign failed = 0>
          <#assign NULL = 0>
          <#assign success = 0>
          <#assign total = 0>
          <#list events as event>
            <#assign total = total + 1>
            <#if event.get('reason') == "timeout">
              <#assign timeout = timeout + 1>
            </#if>
            <#if event.get('reason') == "aborted">
              <#assign aborted = aborted + 1>
            </#if>
            <#if event.get('reason') == "unstable">
              <#assign unstable = unstable + 1>
            </#if>
           <#if event.get('reason') == "failed">
              <#assign failed = failed + 1>
            </#if>
            <#if event.get('reason') == "NULL">
              <#assign NULL = NULL + 1>
            </#if>
            <#if event.get('reason') == "success">
              <#assign success = success + 1>
            </#if>
          </#list>
          <tr>
            <td>${slave}</td>
            <td>${total}</td>
            <td>${success}</td>
            <td>${unstable}</td>
            <td>${failed}</td>
            <td>${NULL}</td>
            <td>${timeout}</td>
          </tr>
        </#if>
        </#list>
</#macro>

<h1></h1>
<table class="table table-condensed table-striped">
  <caption>Execution results per slice</caption>
  <tbody>
  <#assign runs = [testRun] >            
  
<@STATUS title="Job status per Slave"/>
  </tbody>
</table>