
id = testRun.getTestRunId()


events = testRun.getEvents(queryParameters)

if events:
    passed = 0
    failed = 0
    not_run = 0
    known_issue = 0
    timeout = 0
    for ev in events:
        if ev.type == 'result':
            p = ev.getProperties()
            result = p.get('result')
            if result is None:
                continue

            if result == 'PASSED':
                passed = passed + 1
            elif result == 'KNOWN ISSUE':
                known_issue = known_issue + 1
            elif result == 'NOT RUN':
                not_run = not_run + 1
            else:
                failed = failed + 1
        elif ev.type == 'jobStatus' and ev.getProperties().get('reason') == 'timeout':
            ntests = ev.getProperties().get('ntests')
            if ntests is None:
                ntests = 0
            timeout = timeout + ntests


    resultHolder.setResult(
        {
            'chart': {
                'type': 'pie',
                'plotBackgroundColor': None,
                'plotBorderWidth': None,
                'plotShadow': False
            },
            'title': {
                'text': 'Test count'
            },
            'tooltip': {
        	    'pointFormat': '{series.name}: <b>{point.percentage:.1f}%</b>'
            },
            'credits': {
                'enabled': False
            },
            'colors': ['#ABD718', '#D31155', '#055F75', '#E36C16', '#009190'],
            'plotOptions': {
                'pie': {
                    'allowPointSelect': True,
                    'cursor': 'pointer',
                    'dataLabels': {
                        'enabled': True,
                        'format': '{y}'
                    },
                    'showInLegend': 'True',
                    'animation': False
                }
            },
            'series': [{
                'data': [
                    ['Passed', passed],
                    ['Failed', failed],
                    ['Not Run', not_run],
                    ['Known Issue', known_issue],
                    ['Timeout', timeout]
                ]
            }]
        })