map = dict(event.getProperties())
map['environment'] = testRun.hasProperty('environment') and testRun.getProperty('environment') or ''

def deriveTeam(tags):
    teams = [tag for tag in tags if tag.lower().startswith('team')]
    return teams and teams[0][4:] or ''

tags = map.get("tags")
if tags:
    map['team'] = deriveTeam(tags)

pageProperties = map.get('properties')
if pageProperties and pageProperties.get('issue'):
    map['result'] = 'KNOWN ISSUE'
    map['issue'] = pageProperties.get('issue')
else:
    map['issue'] = ''
    
if pageProperties and pageProperties.get('priority'):
    map['priority'] = pageProperties.get('priority')
else:
    map['priority'] = ''

if pageProperties and pageProperties.get('testcase'):
    map['testcasedescription'] = pageProperties.get('testcase')
else:
    map['testcasedescription'] = ''
    
if map.get('pageName'):
    pageName = map['pageName']
    map['testset'] = pageName
    page_parts = pageName.split('.')
    # page_parts[0] == 'FrontPage'
    map['application'] = len(page_parts) > 1 and page_parts[1] or ''
    map['applicationPackage'] = len(page_parts) > 2 and page_parts[2] or ''
    map['usecase'] = len(page_parts) > 3 and page_parts[3] or ''
    map['testcase'] = len(page_parts) > 4 and page_parts[4] or ''
   
if map.get('timestamp'):
    map['run_time'] = map['timestamp']

resultHolder.setResult(map)
