package com.xebialabs.xltest.bol;

import java.io.IOException;
import java.net.URI;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.xltest.domain.TestRun;
import com.xebialabs.xltest.domain.TestSetDefinition;
import com.xebialabs.xltest.service.TestRunner;



@Controller
@Path("/rerun")
@Produces(MediaType.APPLICATION_JSON)
@Consumes(MediaType.APPLICATION_JSON)
public class RerunTestController {
	private static final Logger LOG = LoggerFactory.getLogger(RerunTestController.class);
	
    private final RepositoryService repository;
    private final TestRunner testRunner;

    @Autowired
    public RerunTestController(RepositoryService repository, TestRunner testRunner) {
        this.repository = repository;
        this.testRunner = testRunner;
    }
    
	@GET
	@Path("{testRunId:[\\w-]+}/{suite:.+}")
	public Response rerunSlice(@PathParam("testRunId") String testRunId, @PathParam("suite") String suite, @HeaderParam("xltest-base") String xlTestBase, @Context final UriInfo uriInfo)
			throws IOException, InterruptedException {
		LOG.info("Attempting to re-run suite {} that was part of test run {}", suite, testRunId);
		TestRun oldRun = findOldRun(testRunId);
		TestSetDefinition systemSlicedRerunDefinition = findAndCreateIfNecessary(oldRun, suite);
		Type runType = oldRun.getType();
		TestRun testRun = runType.getDescriptor().newInstance("");
		testRun.setTestSetDefinition(systemSlicedRerunDefinition);
		testRun.setProperty("jenkinsUri", oldRun.getProperty("jenkinsUri"));
		testRun.setProperty("jobName", oldRun.getProperty("jobName"));
		testRun.setProperty("maxQueueSize", oldRun.getProperty("maxQueueSize"));
		testRun.setProperty("environment", oldRun.getProperty("environment"));
		testRun.setProperty("browser", oldRun.getProperty("browser"));
		testRun.setProperty("suiteFilter", oldRun.getProperty("suiteFilter"));
		TestRun newRun = fireTest(testRun, xlTestBase, uriInfo);
		String newRunId = newRun.getName();
		URI location = URI.create("#/testruns/" + newRunId);
		return Response.temporaryRedirect(location).build();
	}
    
	public TestRun fireTest(final TestRun testRun, String xlTestBase, UriInfo uriInfo) throws IOException, InterruptedException {
        URI xlTestBaseUri;
        if (xlTestBase != null) {
            xlTestBaseUri = URI.create(xlTestBase + "/test");
        } else {
            xlTestBaseUri = uriInfo.getAbsolutePath();
        }
        return testRunner.run(testRun, xlTestBaseUri);
	}

	private TestRun findOldRun(String testRunId) {
		return repository.read("Applications/TestRuns/" + testRunId);
	}

	private TestSetDefinition findAndCreateIfNecessary(TestRun oldRun, String suite) {
		TestSetDefinition systemSliceRerun = null;
		String id = "Configuration/TestSetDefinitions/systemSliceRerun";
		try {
			systemSliceRerun = repository.read(id);
		} catch (NotFoundException nfe) {
			Type bolSlice = Type.valueOf("bol.SlicedFitNesseSubSet");
			systemSliceRerun = bolSlice.getDescriptor().newInstance(id);
			systemSliceRerun.setProperty("parent", oldRun.getTestSetDefinition());
			repository.create(systemSliceRerun);
		}
		systemSliceRerun.setProperty("suiteName", suite);
		return systemSliceRerun;
	}



}

