<#macro RESULTTYPE result title>
<tr>
  <th colspan="9"><h3>${title}</h3></th>
</tr>
<tr>
    <th>Use case Suite</th><th>Use case</th><th>Test Case</th><th>Priority</th><th>Team</th><th>Issue</th><th>Browser</th><th>Runtime</th><th>Info</th>
</tr>
<#list events as event>
  <#if event.type == 'result' && event.get('result') == result>
    <tr>
      <#assign application = event.get('application')>
      <#assign applicationPackage = event.get('applicationPackage')>
      <#assign usecase = event.get('usecase')>
      <#assign testcase = event.get('testcase')>
      <#assign buildNumber = event.get('buildNumber') >
      <#assign pageName = event.get('pageName') >
      <td><a href="http://localhost:8084/FrontPage.${application}.${applicationPackage}">${applicationPackage}</a></td>
      <td><a href="http://localhost:8084/FrontPage.${application}.${applicationPackage}.${usecase}">${usecase}</a></td>
      <td><a href="http://localhost:8084/FrontPage.${application}.${applicationPackage}.${usecase}.${testcase}">${testcase}</a></td>
      <td>
        <#if event.hasProperty('priority')>
          ${event.get('priority')}
        </#if>
      </td>
      <td>
        <#if event.hasProperty('team')>
          ${event.get('team')}
        </#if>
      </td>
      <td>
        <#if event.hasProperty('issue')>
          <a href="${event.get('issue')}">${event.get('issue')}</a>
        </#if>
      </td>
      <td>
        <#if event.hasProperty('browser')>
          ${event.get('browser')}
        </#if>
      </td>
      <td>
        <#if event.hasProperty('run_time')>
            <#if jenkins_job_url??>
              <a href="${jenkins_job_url}${buildNumber}/Fitnesse_Report/${pageName}.html">${event.get('run_time')?number_to_datetime}</a>
            <#else>
          	  ${event.get('run_time')?number_to_datetime}
          	</#if>
        </#if>
      </td>
      <td>
        <#if event.hasProperty('info')>
            <#if jenkins_job_url??>
              <a href="${jenkins_job_url}${buildNumber}/artifact/FitNesseRoot/files/testResults/screenshots/FrontPage.${application}.${applicationPackage}.${usecase}">${event.get('info')}</a>
            <#else>
          	  ${event.get('info')}
          	</#if>
        </#if>
      </td>
    </tr>
    <tr class="secondary">
      <td colspan="8">
        <#if event.hasProperty('testcasedescription')>
          ${event.get('testcasedescription')}
        </#if>
        <#if event.hasProperty('firstError')>
          <br/>
          <span class="label label-danger">${event.get('firstError')}</span>
        </#if>
        <#if queryParameters?size &gt; 3>
          <#assign correspondingOlderEvents = testRun.getCorrespondingEventsFromOlderRuns(event, 10, 'type', 'pageName')>
          <#assign olderResults = "">
          <#list correspondingOlderEvents as olderEvent>
            <#assign oldResult = event.get('result')!"">
            <#assign olderResults = olderResults + oldResult + " ">
          </#list>
          <br/>
          Older results for this test: ${olderResults}
        </#if>
      </td>
    </tr>
  </#if>
</#list>
</#macro>

<#assign events = testRun.getEvents(queryParameters, 'pageName') >
<#assign jenkinsUri = testRun.getProperty('jenkinsUri') >
<#assign jobName = testRun.getProperty('jobName') >
<#assign jenkins_job_url = jenkinsUri + "/job/" + jobName + "/">

<table class="table">
<tbody>
<@RESULTTYPE result="FAILED" title="Failed"/>
<@RESULTTYPE result="NOT RUN" title="Not Run"/>
<#if queryParameters?size &gt; 0>
<@RESULTTYPE result="KNOWN ISSUE" title="Known Failed"/>
<@RESULTTYPE result="PASSED" title="Passed"/>
</#if>
</tbody>
</table>

