# self is an instance of Report, 'repository' is the JCR repo and 'testRun' contains info about the run.
# pass the result into 'resultholder' like this: resultHolder.setResult({ 'success': success })

from java.util import Date
import operator
from java.lang import IllegalArgumentException
from urllib2 import quote


def nextDrilldownLevel(drilldownsequence, queryParameters):
    keys = queryParameters.keySet()
    for drilldown in drilldownsequence:
        if not keys.contains(drilldown):
            print 'xaxis computed to be', drilldown
            return drilldown, True
    return drilldownsequence[-1], False

def makeDrilldownUrl(xaxis):
    drilldown = self.getProperty('drilldown')
    queryStr = '&'.join(quote(k) + '=' + quote(v) for k, v in dict(queryParameters).iteritems())
    queryStr = queryStr and (queryStr + '&') or ''
    if drilldown:
        return '%s/%s?%s%s=' % (id, drilldown.id, queryStr, xaxis)
    else:
        return ''

def aggregate_results(events, timeouts, keyAttr='pageName'):
    agg = {}
    applied_timeouts = set()
    for e in events:
        key = e.get(keyAttr)
        other = agg.get(key)
        if not other or other.get('_ts') < e.get('_ts'):
            agg[key] = e
        for to in timeouts:
            if key.startswith(to.get('suiteName')) and to.get('_ts') > e.get('_ts'):
                agg[key] = to
                applied_timeouts.add(to)
                break
    return agg, applied_timeouts

def get_environment(testRun):
    'Not all events have an environment property. Implement a default'
    try:
        return testRun.getProperty('environment')
    except IllegalArgumentException:
        return "DEVELOP"

#def make_column_values(group_map, categories):
#    return map(lambda t: group_map.has_key(t) and { 'y': sum(group_map[t]), 'url': URL and (URL + t) } or None, categories)


id = testRun.getTestRunId()
environment = get_environment(testRun)
startTime = testRun.startTime
drilldownsequence = self.getProperty('drilldownsequence')
xaxis, canDrillDown = nextDrilldownLevel(drilldownsequence, queryParameters)
URL = makeDrilldownUrl(xaxis)

now = testRun.finishedTime or Date()
a_day_ago = Date(now.time - 48 * 60 * 60 * 1000)
finished_events = testRun.getEventsBetween(a_day_ago.time, now.time, {'type': 'jobStatus', 'status': 'finished', 'environment': environment})

test_run_ids = set(map(operator.attrgetter('testRunId'), finished_events))


results = []
eventProperties = {'type': 'result', 'run_id': id.toString()}
eventProperties.update(queryParameters)
for id in test_run_ids:
    results.extend(testRun.getEventsBetween(a_day_ago.time, now.time, eventProperties))

print 'Have found', len(results), 'events for our identified runs'

def matchingQueryParameters(e):
    for k, v in dict(queryParameters).iteritems():
        if not e.hasProperty(k) or e.get(k) != v:
            return False
    return True

timeouts = [ e for e in finished_events if e.properties.get('reason') == 'timeout' and matchingQueryParameters(e)]

event_map, applied_timeouts = aggregate_results(results, timeouts)

# Okay, at this point event_map is a map[page name -> event].

if event_map:
    passed = []
    failed = []
    known = []
    notrun = []
    timeout = []
    for ev in event_map.itervalues():
        x = ev.get(xaxis)
        if x and ev.type == 'result':
            result = ev.get('result')
            if x is None:
                continue
            if result == 'PASSED':
                passed.append(1)
            elif result == 'KNOWN ISSUE':
                known.append(1)
            elif result == 'NOT RUN':
                notrun.append(1)
            else:
                failed.append(1)
        if x and ev.type == 'jobStatus': # The timeout events:
            timeout.append(1)
    for to in timeouts:
        if to in applied_timeouts:
            continue
        x = to.get(xaxis)
        if x:
            ntests = to.get('ntests')
            if ntests is None:
                ntests = 0
            timeout.append(int(ntests))

    #categories = sorted(set(failed.keys() + passed.keys() + known.keys() + notrun.keys() + timeout.keys()))

    #passed = make_column_values(passed, categories)
    #failed = make_column_values(failed, categories)
    #known = make_column_values(known, categories)
    #notrun = make_column_values(notrun, categories)
    #timeout = make_column_values(timeout, categories)

    #categories = map(lambda x: x[:20], categories)

    #if xaxis == 'team':
    #    rotation = 0
    #else:
    #    rotation = -45


    resultHolder.setResult(
        {
            'chart': {
                'type': 'pie',
                'plotBackgroundColor': None,
                'plotBorderWidth': None,
                'plotShadow': False
            },
            'title': {
                'text': 'Test count'
            },
            'tooltip': {
                'pointFormat': '{series.name}: <b>{point.percentage:.1f}%</b>'
            },
            'credits': {
                'enabled': False
            },
            'colors': ['#ABD718', '#D31155', '#055F75', '#E36C16', '#009190'],
            'plotOptions': {
                'pie': {
                    'allowPointSelect': True,
                    'cursor': 'pointer',
                    'dataLabels': {
                        'enabled': True,
                        'format': '{y}'
                    },
                    'showInLegend': 'True',
                    'animation': False
                }
            },
            'series': [{
                           'data': [
                               ['Passed', sum(filter(None, passed))],
                               ['Failed', sum(filter(None, failed))],
                               ['Not Run', sum(filter(None, notrun))],
                               ['Known Issue', sum(filter(None, known))],
                               ['Timeout', sum(filter(None, timeout))]
                           ]
                       }]
        })

