import os.path
import re
from xml.etree import ElementTree as etree

if event.hasProperty('reason') and event.getProperties().get('reason') == 'timeout':

    map = dict(event.getProperties())

    WIKI_WORD = re.compile(r'^[A-Z][a-z]+(?:[A-Z][a-z0-9]*)+$')


    workingDir = ''
    if testRun.testSetDefinition.hasProperty('workingDir'):
        workingDir = testRun.testSetDefinition.getProperty('workingDir')
    suiteName = ''
    if event.hasProperty('suiteName'):
        suiteName = event.get('suiteName')
        map['testset'] = suiteName
        page_parts = suiteName.split('.')
        # page_parts[0] == 'FrontPage'
        map['application'] = len(page_parts) > 1 and page_parts[1]
        map['applicationPackage'] = len(page_parts) > 2 and page_parts[2]
        map['usecase'] = len(page_parts) > 3 and page_parts[3]
        map['testcase'] = len(page_parts) > 4 and page_parts[4]

    print 'workingDir', workingDir
    print 'suiteName', suiteName

    path = workingDir + os.path.sep + 'FitNesseRoot' + os.path.sep + suiteName.replace('.', os.path.sep)
    print 'path in which to count directories', path
    ntests = 0
    team = ''
    if os.path.isdir(path):
        for fileToProcess in os.listdir(path):
            if os.path.isdir(path + os.path.sep + fileToProcess) and WIKI_WORD.match(fileToProcess):
                ntests += 1
                if not team:
                    propertyFileOfTest = path + os.path.sep + fileToProcess + os.path.sep + 'properties.xml'
                    if not os.path.isfile(propertyFileOfTest):
                        continue
                    dom = etree.parse(file(propertyFileOfTest))
                    suites = dom.findtext('//Suites')
                    if suites:
                        tags = suites.replace(' ','').split(',')
                        teamInList = filter(lambda t: t.lower().startswith('team'), tags)
                        team = teamInList and teamInList[0][4:] or ''

    else:
        print 'Error. Can not find directory', path, 'so I cannot determine the number of tests that are not run'


    print 'team', team
    print 'ntests', ntests
    map['team'] = team
    map['ntests'] = ntests

    resultHolder.setResult(map)

else:
    resultHolder.setResult(event.getProperties())