<#macro STATUS reason title>
    <#assign shouldPrintHeader = true >

        <#assign reasonKv = 'reason:' + reason>
        <#assign eventsMap = testRun.getEventsFromRunsAsMapGroupedBy('suiteName', runs, reasonKv, 'type:jobStatus', 'status:finished')>
        <#list eventsMap?keys as suiteName>
          <#if shouldPrintHeader >
            <tr>
              <th colspan="4"><h3>${title}</h3></th>
            </tr>
            <tr>
              <th>Suitename</th><th>Duration (min)</th><th>Average Duration (min)</th><th>Previous Durations (min)</th>
            </tr>
            <#assign shouldPrintHeader = false >
          </#if>
          <#assign events = eventsMap[suiteName] >
          <#assign first = true >
          <#assign olderDurations = "">
          <#list events as event>
            <#if first >
              <#assign duration = (event._ts - event.started) / 60000>
              <#assign durationsTotal = duration>
              <#assign numberOfDurations = 1>
              <#assign first = false >
            <#else>
              <#assign oldDuration = (event._ts - event.started) / 60000>
              <#assign durationsTotal = durationsTotal + oldDuration>
              <#assign numberOfDurations = numberOfDurations + 1>
              <#assign olderDurations = olderDurations + " " + oldDuration>
            </#if>
          </#list>
          <#assign avg = durationsTotal / numberOfDurations>
          <tr>
            <td>${suiteName}</td>
            <td>${duration}</td>
            <td>${avg}</td>
            <td>${olderDurations}</td>
          </tr>
        </#list>
</#macro>

<h1></h1>
<table class="table table-condensed table-striped">
  <caption>Execution results per slice</caption>
  <tbody>
  <#assign runs = testRun.getPreviousRunsIncludingThisOne(10) >            
  
<@STATUS reason="timeout" title="Slice execution Timed Out"/>
<@STATUS reason="aborted" title="Slice execution Aborted by user"/>
<@STATUS reason="unstable" title="Slice execution considered Unstable"/>
<@STATUS reason="failed" title="Slice execution Failed misserably"/>
<@STATUS reason="NULL" title="Slice ended in Unknown state"/>
<@STATUS reason="success" title="Slice executed Successfully"/>
  </tbody>
</table>