package com.xebialabs.xlplatform.webhooks.queue.configuration

import javax.jms.ConnectionFactory
import org.apache.activemq.ActiveMQConnectionFactory
import org.springframework.jms.config.DefaultJmsListenerContainerFactory
import org.springframework.jms.connection.CachingConnectionFactory
import org.springframework.jms.core.JmsTemplate

class EmbeddedQueueConfiguration() extends AbstractQueueConfiguration {

  lazy val receiverActiveMQConnectionFactory: ActiveMQConnectionFactory = {
    val activeMQConnectionFactory = new ActiveMQConnectionFactory
    activeMQConnectionFactory.setBrokerURL("vm://embedded-broker?broker.persistent=false&broker.useShutdownHook=false")
    activeMQConnectionFactory.setTrustAllPackages(true)
    activeMQConnectionFactory
  }

  override def jmsConnectionFactory: ConnectionFactory = receiverActiveMQConnectionFactory

  override def jmsTemplate: JmsTemplate = {
    new JmsTemplate(new CachingConnectionFactory(receiverActiveMQConnectionFactory))
  }

  override def jmsListenerContainerFactory: DefaultJmsListenerContainerFactory = {
    val factory = new DefaultJmsListenerContainerFactory()
    // This provides all boot's default to this factory, including the message converter
    factory.setConnectionFactory(receiverActiveMQConnectionFactory)
    // You could still override some of Boot's default if necessary.
    factory
  }

}
