package com.xebialabs.xlplatform.webhooks.queue

import com.xebialabs.xlplatform.webhooks.events.domain.{Event, EventConsumer}
import com.xebialabs.xlplatform.webhooks.events.handlers.EventConsumerHandler
import grizzled.slf4j.Logging
import org.springframework.jms.annotation.JmsListener

// EventConsumer that consumes messages received from a JMS queue
trait JmsEventListenerHandler[
  E <: Event,
  P <: EventConsumer,
] extends EventConsumerHandler[E, P] with Logging {

  def config: P

  @JmsListener(destination = "${xl.queue.queueName}")
  def listen(event: E): Unit = {
    logger.debug(s"Received event: $event")
    consume(config, event)
  }

}
