package com.xebialabs.xlplatform.utils

import java.net.URL

import com.xebialabs.xlplatform.utils.ClassLoaderUtils.classLoader

import scala.xml.{Elem, XML}

object ResourceUtils {

  def findResources(filePattern: String): Seq[URL] = {
    import scala.collection.JavaConverters._
    classLoader.getResources(filePattern).asScala.toSeq
  }

  def loadXmlResources(filePattern: String): Map[URL, Elem] = {
    import com.xebialabs.xlplatform.utils.ResourceManagement._

    val storeResource = (acc: Map[URL, Elem], next: URL) => {
      map(next.openStream()) { s => acc + (next -> XML.load(s)) }
    }

    findResources(filePattern).foldLeft(Map[URL, Elem]())(storeResource)
  }

  def getResourcePath(res: String): Option[String] = {
    Option(classLoader.getResource(res)).map(_.toURI.getPath)
  }

  def getClassResourcePath(c: Class[_], res: String): Option[String] = {
    Option(c.getResource(res)).map(_.toURI.getPath)
  }
}
